package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementSpecFluentImpl<A extends PlacementSpecFluent<A>> extends BaseFluent<A> implements PlacementSpecFluent<A>{
  public PlacementSpecFluentImpl() {
  }
  public PlacementSpecFluentImpl(PlacementSpec instance) {
    this.withClusterSets(instance.getClusterSets()); 
    this.withNumberOfClusters(instance.getNumberOfClusters()); 
    this.withPredicates(instance.getPredicates()); 
    this.withPrioritizerPolicy(instance.getPrioritizerPolicy()); 
  }
  private List<String> clusterSets = new ArrayList<String>();
  private Integer numberOfClusters;
  private ArrayList<ClusterPredicateBuilder> predicates = new ArrayList<ClusterPredicateBuilder>();
  private PrioritizerPolicyBuilder prioritizerPolicy;
  public A addToClusterSets(Integer index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.add(index, item);
    return (A)this;
  }
  public A setToClusterSets(Integer index,String item) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    this.clusterSets.set(index, item); return (A)this;
  }
  public A addToClusterSets(java.lang.String... items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  public A addAllToClusterSets(Collection<String> items) {
    if (this.clusterSets == null) {this.clusterSets = new ArrayList<String>();}
    for (String item : items) {this.clusterSets.add(item);} return (A)this;
  }
  public A removeFromClusterSets(java.lang.String... items) {
    for (String item : items) {if (this.clusterSets!= null){ this.clusterSets.remove(item);}} return (A)this;
  }
  public A removeAllFromClusterSets(Collection<String> items) {
    for (String item : items) {if (this.clusterSets!= null){ this.clusterSets.remove(item);}} return (A)this;
  }
  public List<String> getClusterSets() {
    return this.clusterSets;
  }
  public String getClusterSet(Integer index) {
    return this.clusterSets.get(index);
  }
  public String getFirstClusterSet() {
    return this.clusterSets.get(0);
  }
  public String getLastClusterSet() {
    return this.clusterSets.get(clusterSets.size() - 1);
  }
  public String getMatchingClusterSet(Predicate<String> predicate) {
    for (String item: clusterSets) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingClusterSet(Predicate<String> predicate) {
    for (String item: clusterSets) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterSets(List<String> clusterSets) {
    if (clusterSets != null) {this.clusterSets = new ArrayList(); for (String item : clusterSets){this.addToClusterSets(item);}} else { this.clusterSets = null;} return (A) this;
  }
  public A withClusterSets(java.lang.String... clusterSets) {
    if (this.clusterSets != null) {this.clusterSets.clear();}
    if (clusterSets != null) {for (String item :clusterSets){ this.addToClusterSets(item);}} return (A) this;
  }
  public Boolean hasClusterSets() {
    return clusterSets != null && !clusterSets.isEmpty();
  }
  public Integer getNumberOfClusters() {
    return this.numberOfClusters;
  }
  public A withNumberOfClusters(Integer numberOfClusters) {
    this.numberOfClusters=numberOfClusters; return (A) this;
  }
  public Boolean hasNumberOfClusters() {
    return this.numberOfClusters != null;
  }
  public A addToPredicates(Integer index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(index >= 0 ? index : _visitables.get("predicates").size(), builder);this.predicates.add(index >= 0 ? index : predicates.size(), builder); return (A)this;
  }
  public A setToPredicates(Integer index,ClusterPredicate item) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);
    if (index < 0 || index >= _visitables.get("predicates").size()) { _visitables.get("predicates").add(builder); } else { _visitables.get("predicates").set(index, builder);}
    if (index < 0 || index >= predicates.size()) { predicates.add(builder); } else { predicates.set(index, builder);}
     return (A)this;
  }
  public A addToPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  public A addAllToPredicates(Collection<ClusterPredicate> items) {
    if (this.predicates == null) {this.predicates = new ArrayList<ClusterPredicateBuilder>();}
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").add(builder);this.predicates.add(builder);} return (A)this;
  }
  public A removeFromPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... items) {
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder);if (this.predicates != null) {this.predicates.remove(builder);}} return (A)this;
  }
  public A removeAllFromPredicates(Collection<ClusterPredicate> items) {
    for (ClusterPredicate item : items) {ClusterPredicateBuilder builder = new ClusterPredicateBuilder(item);_visitables.get("predicates").remove(builder);if (this.predicates != null) {this.predicates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromPredicates(Predicate<ClusterPredicateBuilder> predicate) {
    if (predicates == null) return (A) this;
    final Iterator<ClusterPredicateBuilder> each = predicates.iterator();
    final List visitables = _visitables.get("predicates");
    while (each.hasNext()) {
      ClusterPredicateBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildPredicates instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterPredicate> getPredicates() {
    return predicates != null ? build(predicates) : null;
  }
  public List<ClusterPredicate> buildPredicates() {
    return predicates != null ? build(predicates) : null;
  }
  public ClusterPredicate buildPredicate(Integer index) {
    return this.predicates.get(index).build();
  }
  public ClusterPredicate buildFirstPredicate() {
    return this.predicates.get(0).build();
  }
  public ClusterPredicate buildLastPredicate() {
    return this.predicates.get(predicates.size() - 1).build();
  }
  public ClusterPredicate buildMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    for (ClusterPredicateBuilder item: predicates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    for (ClusterPredicateBuilder item: predicates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withPredicates(List<ClusterPredicate> predicates) {
    if (this.predicates != null) { _visitables.get("predicates").removeAll(this.predicates);}
    if (predicates != null) {this.predicates = new ArrayList(); for (ClusterPredicate item : predicates){this.addToPredicates(item);}} else { this.predicates = null;} return (A) this;
  }
  public A withPredicates(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterPredicate... predicates) {
    if (this.predicates != null) {this.predicates.clear();}
    if (predicates != null) {for (ClusterPredicate item :predicates){ this.addToPredicates(item);}} return (A) this;
  }
  public Boolean hasPredicates() {
    return predicates != null && !predicates.isEmpty();
  }
  public PlacementSpecFluent.PredicatesNested<A> addNewPredicate() {
    return new PlacementSpecFluentImpl.PredicatesNestedImpl();
  }
  public PlacementSpecFluent.PredicatesNested<A> addNewPredicateLike(ClusterPredicate item) {
    return new PlacementSpecFluentImpl.PredicatesNestedImpl(-1, item);
  }
  public PlacementSpecFluent.PredicatesNested<A> setNewPredicateLike(Integer index,ClusterPredicate item) {
    return new PlacementSpecFluentImpl.PredicatesNestedImpl(index, item);
  }
  public PlacementSpecFluent.PredicatesNested<A> editPredicate(Integer index) {
    if (predicates.size() <= index) throw new RuntimeException("Can't edit predicates. Index exceeds size.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  public PlacementSpecFluent.PredicatesNested<A> editFirstPredicate() {
    if (predicates.size() == 0) throw new RuntimeException("Can't edit first predicates. The list is empty.");
    return setNewPredicateLike(0, buildPredicate(0));
  }
  public PlacementSpecFluent.PredicatesNested<A> editLastPredicate() {
    int index = predicates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last predicates. The list is empty.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  public PlacementSpecFluent.PredicatesNested<A> editMatchingPredicate(Predicate<ClusterPredicateBuilder> predicate) {
    int index = -1;
    for (int i=0;i<predicates.size();i++) { 
    if (predicate.test(predicates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching predicates. No match found.");
    return setNewPredicateLike(index, buildPredicate(index));
  }
  
  /**
   * This method has been deprecated, please use method buildPrioritizerPolicy instead.
   * @return The buildable object.
   */
  @Deprecated
  public PrioritizerPolicy getPrioritizerPolicy() {
    return this.prioritizerPolicy!=null ?this.prioritizerPolicy.build():null;
  }
  public PrioritizerPolicy buildPrioritizerPolicy() {
    return this.prioritizerPolicy!=null ?this.prioritizerPolicy.build():null;
  }
  public A withPrioritizerPolicy(PrioritizerPolicy prioritizerPolicy) {
    _visitables.get("prioritizerPolicy").remove(this.prioritizerPolicy);
    if (prioritizerPolicy!=null){ this.prioritizerPolicy= new PrioritizerPolicyBuilder(prioritizerPolicy); _visitables.get("prioritizerPolicy").add(this.prioritizerPolicy);} else { this.prioritizerPolicy = null; _visitables.get("prioritizerPolicy").remove(this.prioritizerPolicy); } return (A) this;
  }
  public Boolean hasPrioritizerPolicy() {
    return this.prioritizerPolicy != null;
  }
  public PlacementSpecFluent.PrioritizerPolicyNested<A> withNewPrioritizerPolicy() {
    return new PlacementSpecFluentImpl.PrioritizerPolicyNestedImpl();
  }
  public PlacementSpecFluent.PrioritizerPolicyNested<A> withNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return new PlacementSpecFluentImpl.PrioritizerPolicyNestedImpl(item);
  }
  public PlacementSpecFluent.PrioritizerPolicyNested<A> editPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(getPrioritizerPolicy());
  }
  public PlacementSpecFluent.PrioritizerPolicyNested<A> editOrNewPrioritizerPolicy() {
    return withNewPrioritizerPolicyLike(getPrioritizerPolicy() != null ? getPrioritizerPolicy(): new PrioritizerPolicyBuilder().build());
  }
  public PlacementSpecFluent.PrioritizerPolicyNested<A> editOrNewPrioritizerPolicyLike(PrioritizerPolicy item) {
    return withNewPrioritizerPolicyLike(getPrioritizerPolicy() != null ? getPrioritizerPolicy(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlacementSpecFluentImpl that = (PlacementSpecFluentImpl) o;
    if (clusterSets != null ? !clusterSets.equals(that.clusterSets) :that.clusterSets != null) return false;
    if (numberOfClusters != null ? !numberOfClusters.equals(that.numberOfClusters) :that.numberOfClusters != null) return false;
    if (predicates != null ? !predicates.equals(that.predicates) :that.predicates != null) return false;
    if (prioritizerPolicy != null ? !prioritizerPolicy.equals(that.prioritizerPolicy) :that.prioritizerPolicy != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clusterSets,  numberOfClusters,  predicates,  prioritizerPolicy,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clusterSets != null && !clusterSets.isEmpty()) { sb.append("clusterSets:"); sb.append(clusterSets + ","); }
    if (numberOfClusters != null) { sb.append("numberOfClusters:"); sb.append(numberOfClusters + ","); }
    if (predicates != null && !predicates.isEmpty()) { sb.append("predicates:"); sb.append(predicates + ","); }
    if (prioritizerPolicy != null) { sb.append("prioritizerPolicy:"); sb.append(prioritizerPolicy); }
    sb.append("}");
    return sb.toString();
  }
  class PredicatesNestedImpl<N> extends ClusterPredicateFluentImpl<PlacementSpecFluent.PredicatesNested<N>> implements PlacementSpecFluent.PredicatesNested<N>,Nested<N>{
    PredicatesNestedImpl(Integer index,ClusterPredicate item) {
      this.index = index;
      this.builder = new ClusterPredicateBuilder(this, item);
    }
    PredicatesNestedImpl() {
      this.index = -1;
      this.builder = new ClusterPredicateBuilder(this);
    }
    ClusterPredicateBuilder builder;
    Integer index;
    public N and() {
      return (N) PlacementSpecFluentImpl.this.setToPredicates(index,builder.build());
    }
    public N endPredicate() {
      return and();
    }
    
  }
  class PrioritizerPolicyNestedImpl<N> extends PrioritizerPolicyFluentImpl<PlacementSpecFluent.PrioritizerPolicyNested<N>> implements PlacementSpecFluent.PrioritizerPolicyNested<N>,Nested<N>{
    PrioritizerPolicyNestedImpl(PrioritizerPolicy item) {
      this.builder = new PrioritizerPolicyBuilder(this, item);
    }
    PrioritizerPolicyNestedImpl() {
      this.builder = new PrioritizerPolicyBuilder(this);
    }
    PrioritizerPolicyBuilder builder;
    public N and() {
      return (N) PlacementSpecFluentImpl.this.withPrioritizerPolicy(builder.build());
    }
    public N endPrioritizerPolicy() {
      return and();
    }
    
  }
  
}