package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.lang.Object;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementFluentImpl<A extends PlacementFluent<A>> extends BaseFluent<A> implements PlacementFluent<A>{
  public PlacementFluentImpl() {
  }
  public PlacementFluentImpl(Placement instance) {
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
  }
  private String apiVersion;
  private String kind;
  private ObjectMetaBuilder metadata;
  private PlacementSpecBuilder spec;
  private PlacementStatusBuilder status;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public Boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public Boolean hasKind() {
    return this.kind != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMetadata instead.
   * @return The buildable object.
   */
  @Deprecated
  public ObjectMeta getMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public ObjectMeta buildMetadata() {
    return this.metadata!=null ?this.metadata.build():null;
  }
  public A withMetadata(ObjectMeta metadata) {
    _visitables.get("metadata").remove(this.metadata);
    if (metadata!=null){ this.metadata= new ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} else { this.metadata = null; _visitables.get("metadata").remove(this.metadata); } return (A) this;
  }
  public Boolean hasMetadata() {
    return this.metadata != null;
  }
  public PlacementFluent.MetadataNested<A> withNewMetadata() {
    return new PlacementFluentImpl.MetadataNestedImpl();
  }
  public PlacementFluent.MetadataNested<A> withNewMetadataLike(ObjectMeta item) {
    return new PlacementFluentImpl.MetadataNestedImpl(item);
  }
  public PlacementFluent.MetadataNested<A> editMetadata() {
    return withNewMetadataLike(getMetadata());
  }
  public PlacementFluent.MetadataNested<A> editOrNewMetadata() {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): new ObjectMetaBuilder().build());
  }
  public PlacementFluent.MetadataNested<A> editOrNewMetadataLike(ObjectMeta item) {
    return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildSpec instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlacementSpec getSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public PlacementSpec buildSpec() {
    return this.spec!=null ?this.spec.build():null;
  }
  public A withSpec(PlacementSpec spec) {
    _visitables.get("spec").remove(this.spec);
    if (spec!=null){ this.spec= new PlacementSpecBuilder(spec); _visitables.get("spec").add(this.spec);} else { this.spec = null; _visitables.get("spec").remove(this.spec); } return (A) this;
  }
  public Boolean hasSpec() {
    return this.spec != null;
  }
  public PlacementFluent.SpecNested<A> withNewSpec() {
    return new PlacementFluentImpl.SpecNestedImpl();
  }
  public PlacementFluent.SpecNested<A> withNewSpecLike(PlacementSpec item) {
    return new PlacementFluentImpl.SpecNestedImpl(item);
  }
  public PlacementFluent.SpecNested<A> editSpec() {
    return withNewSpecLike(getSpec());
  }
  public PlacementFluent.SpecNested<A> editOrNewSpec() {
    return withNewSpecLike(getSpec() != null ? getSpec(): new PlacementSpecBuilder().build());
  }
  public PlacementFluent.SpecNested<A> editOrNewSpecLike(PlacementSpec item) {
    return withNewSpecLike(getSpec() != null ? getSpec(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildStatus instead.
   * @return The buildable object.
   */
  @Deprecated
  public PlacementStatus getStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public PlacementStatus buildStatus() {
    return this.status!=null ?this.status.build():null;
  }
  public A withStatus(PlacementStatus status) {
    _visitables.get("status").remove(this.status);
    if (status!=null){ this.status= new PlacementStatusBuilder(status); _visitables.get("status").add(this.status);} else { this.status = null; _visitables.get("status").remove(this.status); } return (A) this;
  }
  public Boolean hasStatus() {
    return this.status != null;
  }
  public PlacementFluent.StatusNested<A> withNewStatus() {
    return new PlacementFluentImpl.StatusNestedImpl();
  }
  public PlacementFluent.StatusNested<A> withNewStatusLike(PlacementStatus item) {
    return new PlacementFluentImpl.StatusNestedImpl(item);
  }
  public PlacementFluent.StatusNested<A> editStatus() {
    return withNewStatusLike(getStatus());
  }
  public PlacementFluent.StatusNested<A> editOrNewStatus() {
    return withNewStatusLike(getStatus() != null ? getStatus(): new PlacementStatusBuilder().build());
  }
  public PlacementFluent.StatusNested<A> editOrNewStatusLike(PlacementStatus item) {
    return withNewStatusLike(getStatus() != null ? getStatus(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlacementFluentImpl that = (PlacementFluentImpl) o;
    if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
    if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
    if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
    if (spec != null ? !spec.equals(that.spec) :that.spec != null) return false;
    if (status != null ? !status.equals(that.status) :that.status != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  metadata,  spec,  status,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (metadata != null) { sb.append("metadata:"); sb.append(metadata + ","); }
    if (spec != null) { sb.append("spec:"); sb.append(spec + ","); }
    if (status != null) { sb.append("status:"); sb.append(status); }
    sb.append("}");
    return sb.toString();
  }
  class MetadataNestedImpl<N> extends ObjectMetaFluentImpl<PlacementFluent.MetadataNested<N>> implements PlacementFluent.MetadataNested<N>,Nested<N>{
    MetadataNestedImpl(ObjectMeta item) {
      this.builder = new ObjectMetaBuilder(this, item);
    }
    MetadataNestedImpl() {
      this.builder = new ObjectMetaBuilder(this);
    }
    ObjectMetaBuilder builder;
    public N and() {
      return (N) PlacementFluentImpl.this.withMetadata(builder.build());
    }
    public N endMetadata() {
      return and();
    }
    
  }
  class SpecNestedImpl<N> extends PlacementSpecFluentImpl<PlacementFluent.SpecNested<N>> implements PlacementFluent.SpecNested<N>,Nested<N>{
    SpecNestedImpl(PlacementSpec item) {
      this.builder = new PlacementSpecBuilder(this, item);
    }
    SpecNestedImpl() {
      this.builder = new PlacementSpecBuilder(this);
    }
    PlacementSpecBuilder builder;
    public N and() {
      return (N) PlacementFluentImpl.this.withSpec(builder.build());
    }
    public N endSpec() {
      return and();
    }
    
  }
  class StatusNestedImpl<N> extends PlacementStatusFluentImpl<PlacementFluent.StatusNested<N>> implements PlacementFluent.StatusNested<N>,Nested<N>{
    StatusNestedImpl(PlacementStatus item) {
      this.builder = new PlacementStatusBuilder(this, item);
    }
    StatusNestedImpl() {
      this.builder = new PlacementStatusBuilder(this);
    }
    PlacementStatusBuilder builder;
    public N and() {
      return (N) PlacementFluentImpl.this.withStatus(builder.build());
    }
    public N endStatus() {
      return and();
    }
    
  }
  
}