package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class PlacementDecisionStatusFluentImpl<A extends PlacementDecisionStatusFluent<A>> extends BaseFluent<A> implements PlacementDecisionStatusFluent<A>{
  public PlacementDecisionStatusFluentImpl() {
  }
  public PlacementDecisionStatusFluentImpl(PlacementDecisionStatus instance) {
    this.withDecisions(instance.getDecisions()); 
  }
  private ArrayList<ClusterDecisionBuilder> decisions = new ArrayList<ClusterDecisionBuilder>();
  public A addToDecisions(Integer index,ClusterDecision item) {
    if (this.decisions == null) {this.decisions = new ArrayList<ClusterDecisionBuilder>();}
    ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);_visitables.get("decisions").add(index >= 0 ? index : _visitables.get("decisions").size(), builder);this.decisions.add(index >= 0 ? index : decisions.size(), builder); return (A)this;
  }
  public A setToDecisions(Integer index,ClusterDecision item) {
    if (this.decisions == null) {this.decisions = new ArrayList<ClusterDecisionBuilder>();}
    ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);
    if (index < 0 || index >= _visitables.get("decisions").size()) { _visitables.get("decisions").add(builder); } else { _visitables.get("decisions").set(index, builder);}
    if (index < 0 || index >= decisions.size()) { decisions.add(builder); } else { decisions.set(index, builder);}
     return (A)this;
  }
  public A addToDecisions(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision... items) {
    if (this.decisions == null) {this.decisions = new ArrayList<ClusterDecisionBuilder>();}
    for (ClusterDecision item : items) {ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);_visitables.get("decisions").add(builder);this.decisions.add(builder);} return (A)this;
  }
  public A addAllToDecisions(Collection<ClusterDecision> items) {
    if (this.decisions == null) {this.decisions = new ArrayList<ClusterDecisionBuilder>();}
    for (ClusterDecision item : items) {ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);_visitables.get("decisions").add(builder);this.decisions.add(builder);} return (A)this;
  }
  public A removeFromDecisions(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision... items) {
    for (ClusterDecision item : items) {ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);_visitables.get("decisions").remove(builder);if (this.decisions != null) {this.decisions.remove(builder);}} return (A)this;
  }
  public A removeAllFromDecisions(Collection<ClusterDecision> items) {
    for (ClusterDecision item : items) {ClusterDecisionBuilder builder = new ClusterDecisionBuilder(item);_visitables.get("decisions").remove(builder);if (this.decisions != null) {this.decisions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromDecisions(Predicate<ClusterDecisionBuilder> predicate) {
    if (decisions == null) return (A) this;
    final Iterator<ClusterDecisionBuilder> each = decisions.iterator();
    final List visitables = _visitables.get("decisions");
    while (each.hasNext()) {
      ClusterDecisionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildDecisions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ClusterDecision> getDecisions() {
    return decisions != null ? build(decisions) : null;
  }
  public List<ClusterDecision> buildDecisions() {
    return decisions != null ? build(decisions) : null;
  }
  public ClusterDecision buildDecision(Integer index) {
    return this.decisions.get(index).build();
  }
  public ClusterDecision buildFirstDecision() {
    return this.decisions.get(0).build();
  }
  public ClusterDecision buildLastDecision() {
    return this.decisions.get(decisions.size() - 1).build();
  }
  public ClusterDecision buildMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
    for (ClusterDecisionBuilder item: decisions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
    for (ClusterDecisionBuilder item: decisions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withDecisions(List<ClusterDecision> decisions) {
    if (this.decisions != null) { _visitables.get("decisions").removeAll(this.decisions);}
    if (decisions != null) {this.decisions = new ArrayList(); for (ClusterDecision item : decisions){this.addToDecisions(item);}} else { this.decisions = null;} return (A) this;
  }
  public A withDecisions(io.fabric8.openclustermanagement.api.model.cluster.v1alpha1.ClusterDecision... decisions) {
    if (this.decisions != null) {this.decisions.clear();}
    if (decisions != null) {for (ClusterDecision item :decisions){ this.addToDecisions(item);}} return (A) this;
  }
  public Boolean hasDecisions() {
    return decisions != null && !decisions.isEmpty();
  }
  public A addNewDecision(String clusterName,String reason) {
    return (A)addToDecisions(new ClusterDecision(clusterName, reason));
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> addNewDecision() {
    return new PlacementDecisionStatusFluentImpl.DecisionsNestedImpl();
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> addNewDecisionLike(ClusterDecision item) {
    return new PlacementDecisionStatusFluentImpl.DecisionsNestedImpl(-1, item);
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> setNewDecisionLike(Integer index,ClusterDecision item) {
    return new PlacementDecisionStatusFluentImpl.DecisionsNestedImpl(index, item);
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> editDecision(Integer index) {
    if (decisions.size() <= index) throw new RuntimeException("Can't edit decisions. Index exceeds size.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> editFirstDecision() {
    if (decisions.size() == 0) throw new RuntimeException("Can't edit first decisions. The list is empty.");
    return setNewDecisionLike(0, buildDecision(0));
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> editLastDecision() {
    int index = decisions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last decisions. The list is empty.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  public PlacementDecisionStatusFluent.DecisionsNested<A> editMatchingDecision(Predicate<ClusterDecisionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<decisions.size();i++) { 
    if (predicate.test(decisions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching decisions. No match found.");
    return setNewDecisionLike(index, buildDecision(index));
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PlacementDecisionStatusFluentImpl that = (PlacementDecisionStatusFluentImpl) o;
    if (decisions != null ? !decisions.equals(that.decisions) :that.decisions != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(decisions,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (decisions != null && !decisions.isEmpty()) { sb.append("decisions:"); sb.append(decisions); }
    sb.append("}");
    return sb.toString();
  }
  class DecisionsNestedImpl<N> extends ClusterDecisionFluentImpl<PlacementDecisionStatusFluent.DecisionsNested<N>> implements PlacementDecisionStatusFluent.DecisionsNested<N>,Nested<N>{
    DecisionsNestedImpl(Integer index,ClusterDecision item) {
      this.index = index;
      this.builder = new ClusterDecisionBuilder(this, item);
    }
    DecisionsNestedImpl() {
      this.index = -1;
      this.builder = new ClusterDecisionBuilder(this);
    }
    ClusterDecisionBuilder builder;
    Integer index;
    public N and() {
      return (N) PlacementDecisionStatusFluentImpl.this.setToDecisions(index,builder.build());
    }
    public N endDecision() {
      return and();
    }
    
  }
  
}