package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class PlacementBuilder extends PlacementFluentImpl<PlacementBuilder> implements VisitableBuilder<Placement,PlacementBuilder>{
  public PlacementBuilder() {
    this(false);
  }
  public PlacementBuilder(Boolean validationEnabled) {
    this(new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent) {
    this(fluent, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Placement(), validationEnabled);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance) {
    this(fluent, instance, false);
  }
  public PlacementBuilder(PlacementFluent<?> fluent,Placement instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  public PlacementBuilder(Placement instance) {
    this(instance,false);
  }
  public PlacementBuilder(Placement instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.validationEnabled = validationEnabled; 
  }
  PlacementFluent<?> fluent;
  Boolean validationEnabled;
  public Placement build() {
    Placement buildable = new Placement(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    return buildable;
  }
  
}