package io.fabric8.openclustermanagement.api.model.cluster.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ClusterPredicateBuilder extends ClusterPredicateFluentImpl<ClusterPredicateBuilder> implements VisitableBuilder<ClusterPredicate,ClusterPredicateBuilder>{
  public ClusterPredicateBuilder() {
    this(false);
  }
  public ClusterPredicateBuilder(Boolean validationEnabled) {
    this(new ClusterPredicate(), validationEnabled);
  }
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent) {
    this(fluent, false);
  }
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ClusterPredicate(), validationEnabled);
  }
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent,ClusterPredicate instance) {
    this(fluent, instance, false);
  }
  public ClusterPredicateBuilder(ClusterPredicateFluent<?> fluent,ClusterPredicate instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withRequiredClusterSelector(instance.getRequiredClusterSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  public ClusterPredicateBuilder(ClusterPredicate instance) {
    this(instance,false);
  }
  public ClusterPredicateBuilder(ClusterPredicate instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withRequiredClusterSelector(instance.getRequiredClusterSelector()); 
    this.validationEnabled = validationEnabled; 
  }
  ClusterPredicateFluent<?> fluent;
  Boolean validationEnabled;
  public ClusterPredicate build() {
    ClusterPredicate buildable = new ClusterPredicate(fluent.getRequiredClusterSelector());
    return buildable;
  }
  
}