package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.Quantity;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ManagedClusterStatusFluentImpl<A extends ManagedClusterStatusFluent<A>> extends BaseFluent<A> implements ManagedClusterStatusFluent<A>{
  public ManagedClusterStatusFluentImpl() {
  }
  public ManagedClusterStatusFluentImpl(ManagedClusterStatus instance) {
    this.withAllocatable(instance.getAllocatable()); 
    this.withCapacity(instance.getCapacity()); 
    this.withClusterClaims(instance.getClusterClaims()); 
    this.withConditions(instance.getConditions()); 
    this.withVersion(instance.getVersion()); 
  }
  private Map<String,Quantity> allocatable;
  private Map<String,Quantity> capacity;
  private ArrayList<ManagedClusterClaimBuilder> clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();
  private List<Condition> conditions = new ArrayList<Condition>();
  private ManagedClusterVersionBuilder version;
  public A addToAllocatable(String key,Quantity value) {
    if(this.allocatable == null && key != null && value != null) { this.allocatable = new LinkedHashMap(); }
    if(key != null && value != null) {this.allocatable.put(key, value);} return (A)this;
  }
  public A addToAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null && map != null) { this.allocatable = new LinkedHashMap(); }
    if(map != null) { this.allocatable.putAll(map);} return (A)this;
  }
  public A removeFromAllocatable(String key) {
    if(this.allocatable == null) { return (A) this; }
    if(key != null && this.allocatable != null) {this.allocatable.remove(key);} return (A)this;
  }
  public A removeFromAllocatable(Map<String,Quantity> map) {
    if(this.allocatable == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.allocatable != null){this.allocatable.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getAllocatable() {
    return this.allocatable;
  }
  public <K,V>A withAllocatable(Map<String,Quantity> allocatable) {
    if (allocatable == null) { this.allocatable =  null;} else {this.allocatable = new LinkedHashMap(allocatable);} return (A) this;
  }
  public Boolean hasAllocatable() {
    return this.allocatable != null;
  }
  public A addToCapacity(String key,Quantity value) {
    if(this.capacity == null && key != null && value != null) { this.capacity = new LinkedHashMap(); }
    if(key != null && value != null) {this.capacity.put(key, value);} return (A)this;
  }
  public A addToCapacity(Map<String,Quantity> map) {
    if(this.capacity == null && map != null) { this.capacity = new LinkedHashMap(); }
    if(map != null) { this.capacity.putAll(map);} return (A)this;
  }
  public A removeFromCapacity(String key) {
    if(this.capacity == null) { return (A) this; }
    if(key != null && this.capacity != null) {this.capacity.remove(key);} return (A)this;
  }
  public A removeFromCapacity(Map<String,Quantity> map) {
    if(this.capacity == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.capacity != null){this.capacity.remove(key);}}} return (A)this;
  }
  public Map<String,Quantity> getCapacity() {
    return this.capacity;
  }
  public <K,V>A withCapacity(Map<String,Quantity> capacity) {
    if (capacity == null) { this.capacity =  null;} else {this.capacity = new LinkedHashMap(capacity);} return (A) this;
  }
  public Boolean hasCapacity() {
    return this.capacity != null;
  }
  public A addToClusterClaims(Integer index,ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(index >= 0 ? index : _visitables.get("clusterClaims").size(), builder);this.clusterClaims.add(index >= 0 ? index : clusterClaims.size(), builder); return (A)this;
  }
  public A setToClusterClaims(Integer index,ManagedClusterClaim item) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("clusterClaims").size()) { _visitables.get("clusterClaims").add(builder); } else { _visitables.get("clusterClaims").set(index, builder);}
    if (index < 0 || index >= clusterClaims.size()) { clusterClaims.add(builder); } else { clusterClaims.set(index, builder);}
     return (A)this;
  }
  public A addToClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A addAllToClusterClaims(Collection<ManagedClusterClaim> items) {
    if (this.clusterClaims == null) {this.clusterClaims = new ArrayList<ManagedClusterClaimBuilder>();}
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").add(builder);this.clusterClaims.add(builder);} return (A)this;
  }
  public A removeFromClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... items) {
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder);if (this.clusterClaims != null) {this.clusterClaims.remove(builder);}} return (A)this;
  }
  public A removeAllFromClusterClaims(Collection<ManagedClusterClaim> items) {
    for (ManagedClusterClaim item : items) {ManagedClusterClaimBuilder builder = new ManagedClusterClaimBuilder(item);_visitables.get("clusterClaims").remove(builder);if (this.clusterClaims != null) {this.clusterClaims.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromClusterClaims(Predicate<ManagedClusterClaimBuilder> predicate) {
    if (clusterClaims == null) return (A) this;
    final Iterator<ManagedClusterClaimBuilder> each = clusterClaims.iterator();
    final List visitables = _visitables.get("clusterClaims");
    while (each.hasNext()) {
      ManagedClusterClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildClusterClaims instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<ManagedClusterClaim> getClusterClaims() {
    return clusterClaims != null ? build(clusterClaims) : null;
  }
  public List<ManagedClusterClaim> buildClusterClaims() {
    return clusterClaims != null ? build(clusterClaims) : null;
  }
  public ManagedClusterClaim buildClusterClaim(Integer index) {
    return this.clusterClaims.get(index).build();
  }
  public ManagedClusterClaim buildFirstClusterClaim() {
    return this.clusterClaims.get(0).build();
  }
  public ManagedClusterClaim buildLastClusterClaim() {
    return this.clusterClaims.get(clusterClaims.size() - 1).build();
  }
  public ManagedClusterClaim buildMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    for (ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    for (ManagedClusterClaimBuilder item: clusterClaims) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withClusterClaims(List<ManagedClusterClaim> clusterClaims) {
    if (this.clusterClaims != null) { _visitables.get("clusterClaims").removeAll(this.clusterClaims);}
    if (clusterClaims != null) {this.clusterClaims = new ArrayList(); for (ManagedClusterClaim item : clusterClaims){this.addToClusterClaims(item);}} else { this.clusterClaims = null;} return (A) this;
  }
  public A withClusterClaims(io.fabric8.openclustermanagement.api.model.cluster.v1.ManagedClusterClaim... clusterClaims) {
    if (this.clusterClaims != null) {this.clusterClaims.clear();}
    if (clusterClaims != null) {for (ManagedClusterClaim item :clusterClaims){ this.addToClusterClaims(item);}} return (A) this;
  }
  public Boolean hasClusterClaims() {
    return clusterClaims != null && !clusterClaims.isEmpty();
  }
  public A addNewClusterClaim(String name,String value) {
    return (A)addToClusterClaims(new ManagedClusterClaim(name, value));
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaim() {
    return new ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl();
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> addNewClusterClaimLike(ManagedClusterClaim item) {
    return new ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl(-1, item);
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> setNewClusterClaimLike(Integer index,ManagedClusterClaim item) {
    return new ManagedClusterStatusFluentImpl.ClusterClaimsNestedImpl(index, item);
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editClusterClaim(Integer index) {
    if (clusterClaims.size() <= index) throw new RuntimeException("Can't edit clusterClaims. Index exceeds size.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editFirstClusterClaim() {
    if (clusterClaims.size() == 0) throw new RuntimeException("Can't edit first clusterClaims. The list is empty.");
    return setNewClusterClaimLike(0, buildClusterClaim(0));
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editLastClusterClaim() {
    int index = clusterClaims.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last clusterClaims. The list is empty.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public ManagedClusterStatusFluent.ClusterClaimsNested<A> editMatchingClusterClaim(Predicate<ManagedClusterClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<clusterClaims.size();i++) { 
    if (predicate.test(clusterClaims.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching clusterClaims. No match found.");
    return setNewClusterClaimLike(index, buildClusterClaim(index));
  }
  public A addToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.add(index, item);
    return (A)this;
  }
  public A setToConditions(Integer index,Condition item) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    this.conditions.set(index, item); return (A)this;
  }
  public A addToConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A addAllToConditions(Collection<Condition> items) {
    if (this.conditions == null) {this.conditions = new ArrayList<Condition>();}
    for (Condition item : items) {this.conditions.add(item);} return (A)this;
  }
  public A removeFromConditions(io.fabric8.kubernetes.api.model.Condition... items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public A removeAllFromConditions(Collection<Condition> items) {
    for (Condition item : items) {if (this.conditions!= null){ this.conditions.remove(item);}} return (A)this;
  }
  public List<Condition> getConditions() {
    return this.conditions;
  }
  public Condition getCondition(Integer index) {
    return this.conditions.get(index);
  }
  public Condition getFirstCondition() {
    return this.conditions.get(0);
  }
  public Condition getLastCondition() {
    return this.conditions.get(conditions.size() - 1);
  }
  public Condition getMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingCondition(Predicate<Condition> predicate) {
    for (Condition item: conditions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConditions(List<Condition> conditions) {
    if (conditions != null) {this.conditions = new ArrayList(); for (Condition item : conditions){this.addToConditions(item);}} else { this.conditions = null;} return (A) this;
  }
  public A withConditions(io.fabric8.kubernetes.api.model.Condition... conditions) {
    if (this.conditions != null) {this.conditions.clear();}
    if (conditions != null) {for (Condition item :conditions){ this.addToConditions(item);}} return (A) this;
  }
  public Boolean hasConditions() {
    return conditions != null && !conditions.isEmpty();
  }
  
  /**
   * This method has been deprecated, please use method buildVersion instead.
   * @return The buildable object.
   */
  @Deprecated
  public ManagedClusterVersion getVersion() {
    return this.version!=null ?this.version.build():null;
  }
  public ManagedClusterVersion buildVersion() {
    return this.version!=null ?this.version.build():null;
  }
  public A withVersion(ManagedClusterVersion version) {
    _visitables.get("version").remove(this.version);
    if (version!=null){ this.version= new ManagedClusterVersionBuilder(version); _visitables.get("version").add(this.version);} else { this.version = null; _visitables.get("version").remove(this.version); } return (A) this;
  }
  public Boolean hasVersion() {
    return this.version != null;
  }
  public A withNewVersion(String kubernetes) {
    return (A)withVersion(new ManagedClusterVersion(kubernetes));
  }
  public ManagedClusterStatusFluent.VersionNested<A> withNewVersion() {
    return new ManagedClusterStatusFluentImpl.VersionNestedImpl();
  }
  public ManagedClusterStatusFluent.VersionNested<A> withNewVersionLike(ManagedClusterVersion item) {
    return new ManagedClusterStatusFluentImpl.VersionNestedImpl(item);
  }
  public ManagedClusterStatusFluent.VersionNested<A> editVersion() {
    return withNewVersionLike(getVersion());
  }
  public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersion() {
    return withNewVersionLike(getVersion() != null ? getVersion(): new ManagedClusterVersionBuilder().build());
  }
  public ManagedClusterStatusFluent.VersionNested<A> editOrNewVersionLike(ManagedClusterVersion item) {
    return withNewVersionLike(getVersion() != null ? getVersion(): item);
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    ManagedClusterStatusFluentImpl that = (ManagedClusterStatusFluentImpl) o;
    if (allocatable != null ? !allocatable.equals(that.allocatable) :that.allocatable != null) return false;
    if (capacity != null ? !capacity.equals(that.capacity) :that.capacity != null) return false;
    if (clusterClaims != null ? !clusterClaims.equals(that.clusterClaims) :that.clusterClaims != null) return false;
    if (conditions != null ? !conditions.equals(that.conditions) :that.conditions != null) return false;
    if (version != null ? !version.equals(that.version) :that.version != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(allocatable,  capacity,  clusterClaims,  conditions,  version,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (allocatable != null && !allocatable.isEmpty()) { sb.append("allocatable:"); sb.append(allocatable + ","); }
    if (capacity != null && !capacity.isEmpty()) { sb.append("capacity:"); sb.append(capacity + ","); }
    if (clusterClaims != null && !clusterClaims.isEmpty()) { sb.append("clusterClaims:"); sb.append(clusterClaims + ","); }
    if (conditions != null && !conditions.isEmpty()) { sb.append("conditions:"); sb.append(conditions + ","); }
    if (version != null) { sb.append("version:"); sb.append(version); }
    sb.append("}");
    return sb.toString();
  }
  class ClusterClaimsNestedImpl<N> extends ManagedClusterClaimFluentImpl<ManagedClusterStatusFluent.ClusterClaimsNested<N>> implements ManagedClusterStatusFluent.ClusterClaimsNested<N>,Nested<N>{
    ClusterClaimsNestedImpl(Integer index,ManagedClusterClaim item) {
      this.index = index;
      this.builder = new ManagedClusterClaimBuilder(this, item);
    }
    ClusterClaimsNestedImpl() {
      this.index = -1;
      this.builder = new ManagedClusterClaimBuilder(this);
    }
    ManagedClusterClaimBuilder builder;
    Integer index;
    public N and() {
      return (N) ManagedClusterStatusFluentImpl.this.setToClusterClaims(index,builder.build());
    }
    public N endClusterClaim() {
      return and();
    }
    
  }
  class VersionNestedImpl<N> extends ManagedClusterVersionFluentImpl<ManagedClusterStatusFluent.VersionNested<N>> implements ManagedClusterStatusFluent.VersionNested<N>,Nested<N>{
    VersionNestedImpl(ManagedClusterVersion item) {
      this.builder = new ManagedClusterVersionBuilder(this, item);
    }
    VersionNestedImpl() {
      this.builder = new ManagedClusterVersionBuilder(this);
    }
    ManagedClusterVersionBuilder builder;
    public N and() {
      return (N) ManagedClusterStatusFluentImpl.this.withVersion(builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}