package io.fabric8.openclustermanagement.api.model.cluster.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ManagedClusterStatusBuilder extends ManagedClusterStatusFluentImpl<ManagedClusterStatusBuilder> implements VisitableBuilder<ManagedClusterStatus,ManagedClusterStatusBuilder>{
  public ManagedClusterStatusBuilder() {
    this(false);
  }
  public ManagedClusterStatusBuilder(Boolean validationEnabled) {
    this(new ManagedClusterStatus(), validationEnabled);
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ManagedClusterStatus(), validationEnabled);
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatusFluent<?> fluent,ManagedClusterStatus instance) {
    this(fluent, instance, false);
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatusFluent<?> fluent,ManagedClusterStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAllocatable(instance.getAllocatable()); 
    fluent.withCapacity(instance.getCapacity()); 
    fluent.withClusterClaims(instance.getClusterClaims()); 
    fluent.withConditions(instance.getConditions()); 
    fluent.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatus instance) {
    this(instance,false);
  }
  public ManagedClusterStatusBuilder(ManagedClusterStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAllocatable(instance.getAllocatable()); 
    this.withCapacity(instance.getCapacity()); 
    this.withClusterClaims(instance.getClusterClaims()); 
    this.withConditions(instance.getConditions()); 
    this.withVersion(instance.getVersion()); 
    this.validationEnabled = validationEnabled; 
  }
  ManagedClusterStatusFluent<?> fluent;
  Boolean validationEnabled;
  public ManagedClusterStatus build() {
    ManagedClusterStatus buildable = new ManagedClusterStatus(fluent.getAllocatable(),fluent.getCapacity(),fluent.getClusterClaims(),fluent.getConditions(),fluent.getVersion());
    return buildable;
  }
  
}