package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class LocalSubjectAccessReviewBuilder extends LocalSubjectAccessReviewFluent<LocalSubjectAccessReviewBuilder> implements VisitableBuilder<LocalSubjectAccessReview,LocalSubjectAccessReviewBuilder>{
  public LocalSubjectAccessReviewBuilder() {
    this(false);
  }
  public LocalSubjectAccessReviewBuilder(Boolean validationEnabled) {
    this(new LocalSubjectAccessReview(), validationEnabled);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new LocalSubjectAccessReview(), validationEnabled);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,LocalSubjectAccessReview instance) {
    this(fluent, instance, false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReviewFluent<?> fluent,LocalSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new LocalSubjectAccessReview());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReview instance) {
    this(instance,false);
  }
  public LocalSubjectAccessReviewBuilder(LocalSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new LocalSubjectAccessReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  LocalSubjectAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public LocalSubjectAccessReview build() {
    LocalSubjectAccessReview buildable = new LocalSubjectAccessReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}