package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenReviewStatusBuilder extends TokenReviewStatusFluent<TokenReviewStatusBuilder> implements VisitableBuilder<TokenReviewStatus,TokenReviewStatusBuilder>{
  public TokenReviewStatusBuilder() {
    this(false);
  }
  public TokenReviewStatusBuilder(Boolean validationEnabled) {
    this(new TokenReviewStatus(), validationEnabled);
  }
  public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenReviewStatus(), validationEnabled);
  }
  public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,TokenReviewStatus instance) {
    this(fluent, instance, false);
  }
  public TokenReviewStatusBuilder(TokenReviewStatusFluent<?> fluent,TokenReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TokenReviewStatus());

    if (instance != null) {
      fluent.withAudiences(instance.getAudiences());
      fluent.withAuthenticated(instance.getAuthenticated());
      fluent.withError(instance.getError());
      fluent.withUser(instance.getUser());
      fluent.withAudiences(instance.getAudiences());
      fluent.withAuthenticated(instance.getAuthenticated());
      fluent.withError(instance.getError());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenReviewStatusBuilder(TokenReviewStatus instance) {
    this(instance,false);
  }
  public TokenReviewStatusBuilder(TokenReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TokenReviewStatus());

    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withAuthenticated(instance.getAuthenticated());
      this.withError(instance.getError());
      this.withUser(instance.getUser());
      this.withAudiences(instance.getAudiences());
      this.withAuthenticated(instance.getAuthenticated());
      this.withError(instance.getError());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public TokenReviewStatus build() {
    TokenReviewStatus buildable = new TokenReviewStatus(fluent.getAudiences(),fluent.getAuthenticated(),fluent.getError(),fluent.buildUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}