/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.okhttp;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.okhttp.OkHttpClientBuilderImpl;
import io.fabric8.kubernetes.client.utils.HttpClientUtils;
import java.util.concurrent.TimeUnit;
import okhttp3.Dispatcher;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.logging.HttpLoggingInterceptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpClientFactory
implements HttpClient.Factory {
    public boolean isDefault() {
        return true;
    }

    protected OkHttpClient.Builder newOkHttpClientBuilder() {
        return new OkHttpClient.Builder();
    }

    protected void additionalConfig(OkHttpClient.Builder builder) {
    }

    public HttpClient.Builder newBuilder() {
        return new OkHttpClientBuilderImpl(this.newOkHttpClientBuilder(), this, null);
    }

    public OkHttpClientBuilderImpl newBuilder(Config config) {
        try {
            Logger reqLogger;
            OkHttpClient.Builder httpClientBuilder = this.newOkHttpClientBuilder();
            if (config.isTrustCerts() || config.isDisableHostnameVerification()) {
                httpClientBuilder.hostnameVerifier((s, sslSession) -> true);
            }
            if ((reqLogger = LoggerFactory.getLogger(HttpLoggingInterceptor.class)).isTraceEnabled()) {
                HttpLoggingInterceptor loggingInterceptor = new HttpLoggingInterceptor();
                loggingInterceptor.setLevel(HttpLoggingInterceptor.Level.BODY);
                httpClientBuilder.addNetworkInterceptor((Interceptor)loggingInterceptor);
            }
            if (config.getWebsocketPingInterval() > 0L) {
                httpClientBuilder.pingInterval(config.getWebsocketPingInterval(), TimeUnit.MILLISECONDS);
            }
            if (config.getMaxConcurrentRequests() > 0 && config.getMaxConcurrentRequestsPerHost() > 0) {
                Dispatcher dispatcher = new Dispatcher();
                dispatcher.setMaxRequests(config.getMaxConcurrentRequests());
                dispatcher.setMaxRequestsPerHost(config.getMaxConcurrentRequestsPerHost());
                httpClientBuilder.dispatcher(dispatcher);
            }
            OkHttpClientBuilderImpl builderWrapper = new OkHttpClientBuilderImpl(httpClientBuilder, this, null);
            HttpClientUtils.applyCommonConfiguration((Config)config, (HttpClient.Builder)builderWrapper, (HttpClient.Factory)this);
            if (this.shouldDisableHttp2() && !config.isHttp2Disable()) {
                builderWrapper.preferHttp11();
            }
            this.additionalConfig(httpClientBuilder);
            return builderWrapper;
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable((Throwable)e);
        }
    }

    protected boolean shouldDisableHttp2() {
        return System.getProperty("java.version", "").startsWith("1.8");
    }
}

