/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.dbmigration.ddlgeneration.platform;

import io.ebean.annotation.ConstraintMode;
import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.DdlIdentity;
import io.ebeaninternal.dbmigration.ddlgeneration.platform.PlatformDdl;

public class OracleDdl
extends PlatformDdl {
    public OracleDdl(DatabasePlatform platform) {
        super(platform);
        this.dropTableIfExists = "drop table ";
        this.dropSequenceIfExists = "drop sequence ";
        this.dropConstraintIfExists = "drop constraint";
        this.dropIndexIfExists = "drop index ";
        this.dropTableCascade = " cascade constraints purge";
        this.alterColumn = "modify";
        this.columnSetNotnull = "not null";
        this.columnSetNull = "null";
        this.columnSetDefault = "default";
        this.identitySuffix = " generated by default as identity";
    }

    @Override
    public String alterTableAddUniqueConstraint(String tableName, String uqName, String[] columns, String[] nullableColumns) {
        if (nullableColumns == null || nullableColumns.length == 0) {
            return super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
        }
        return "-- NOT YET IMPLEMENTED: " + super.alterTableAddUniqueConstraint(tableName, uqName, columns, nullableColumns);
    }

    @Override
    protected void appendForeignKeyOnUpdate(StringBuilder buffer, ConstraintMode mode) {
    }

    @Override
    protected void appendForeignKeyMode(StringBuilder buffer, String onMode, ConstraintMode mode) {
        switch (mode) {
            case SET_NULL: 
            case CASCADE: {
                super.appendForeignKeyMode(buffer, onMode, mode);
            }
        }
    }

    @Override
    public String asIdentityColumn(String columnDefn, DdlIdentity identity) {
        return this.asIdentityStandardOptions(columnDefn, identity);
    }
}

