/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.config.JsonConfig;
import io.ebean.core.type.ScalarTypeBaseDateTime;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;

final class ScalarTypeLocalDateTime
extends ScalarTypeBaseDateTime<LocalDateTime> {
    ScalarTypeLocalDateTime(JsonConfig.DateTime mode) {
        super(mode, LocalDateTime.class, false, 5009);
    }

    public LocalDateTime convertFromMillis(long systemTimeMillis) {
        return new Timestamp(systemTimeMillis).toLocalDateTime();
    }

    public long convertToMillis(LocalDateTime value) {
        return Timestamp.valueOf(value).getTime();
    }

    protected String toJsonNanos(LocalDateTime value) {
        return value.toString();
    }

    protected String toJsonISO8601(LocalDateTime value) {
        return value.toString();
    }

    protected LocalDateTime fromJsonISO8601(String value) {
        return LocalDateTime.parse(value);
    }

    public LocalDateTime jsonRead(JsonParser parser) throws IOException {
        return LocalDateTime.parse(parser.getText());
    }

    public void jsonWrite(JsonGenerator writer, LocalDateTime value) throws IOException {
        writer.writeString(value.toString());
    }

    public String formatValue(LocalDateTime value) {
        return value.toString();
    }

    public LocalDateTime parse(String value) {
        return LocalDateTime.parse(value);
    }

    public LocalDateTime convertFromTimestamp(Timestamp timestamp) {
        return timestamp.toLocalDateTime();
    }

    public LocalDateTime convertFromInstant(Instant ts) {
        return LocalDateTime.ofInstant(ts, ZoneId.systemDefault());
    }

    public Timestamp convertToTimestamp(LocalDateTime dateTime) {
        return Timestamp.valueOf(dateTime);
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((LocalDateTime)value);
    }

    public LocalDateTime toBeanType(Object value) {
        if (value instanceof Timestamp) {
            return this.convertFromTimestamp((Timestamp)value);
        }
        return (LocalDateTime)value;
    }
}

