/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

final class ScalarTypeFloat
extends ScalarTypeBase<Float> {
    ScalarTypeFloat() {
        super(Float.class, true, 7);
    }

    public void bind(DataBinder binder, Float value) throws SQLException {
        if (value == null) {
            binder.setNull(7);
        } else {
            binder.setFloat(value.floatValue());
        }
    }

    public Float read(DataReader reader) throws SQLException {
        return reader.getFloat();
    }

    public Object toJdbcType(Object value) {
        return BasicTypeConverter.toFloat((Object)value);
    }

    public Float toBeanType(Object value) {
        return BasicTypeConverter.toFloat((Object)value);
    }

    public String formatValue(Float t) {
        return t.toString();
    }

    public Float parse(String value) {
        return Float.valueOf(value);
    }

    public Float readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return Float.valueOf(dataInput.readFloat());
    }

    public void writeData(DataOutput dataOutput, Float value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            dataOutput.writeBoolean(true);
            dataOutput.writeFloat(value.floatValue());
        }
    }

    public Float jsonRead(JsonParser parser) throws IOException {
        return Float.valueOf(parser.getFloatValue());
    }

    public void jsonWrite(JsonGenerator writer, Float value) throws IOException {
        writer.writeNumber(value.floatValue());
    }

    public DocPropertyType docType() {
        return DocPropertyType.FLOAT;
    }
}

