/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.DatabaseConfig;
import io.ebean.config.JsonConfig;
import io.ebean.core.type.BasicTypeConverter;
import io.ebean.core.type.ScalarType;
import io.ebeaninternal.server.type.ScalarTypeBool;
import io.ebeaninternal.server.type.ScalarTypeBoolean;
import io.ebeaninternal.server.type.ScalarTypeCalendar;
import io.ebeaninternal.server.type.ScalarTypeMathBigInteger;
import io.ebeaninternal.server.type.ScalarTypeUtilDate;
import java.math.BigInteger;
import java.util.Calendar;
import java.util.Date;

final class DefaultTypeFactory {
    private final DatabaseConfig config;

    public DefaultTypeFactory(DatabaseConfig config) {
        this.config = config;
    }

    ScalarTypeBool createBoolean(String trueValue, String falseValue) {
        try {
            Integer intTrue = BasicTypeConverter.toInteger((Object)trueValue);
            Integer intFalse = BasicTypeConverter.toInteger((Object)falseValue);
            return new ScalarTypeBoolean.IntBoolean(intTrue, intFalse);
        }
        catch (NumberFormatException e) {
            return new ScalarTypeBoolean.StringBoolean(trueValue, falseValue);
        }
    }

    public ScalarTypeBool createBoolean() {
        if (this.config == null) {
            return new ScalarTypeBoolean.Native();
        }
        String trueValue = this.config.getDatabaseBooleanTrue();
        String falseValue = this.config.getDatabaseBooleanFalse();
        if (falseValue != null && trueValue != null) {
            return this.createBoolean(trueValue, falseValue);
        }
        int booleanDbType = this.config.getDatabasePlatform().booleanDbType();
        if (booleanDbType == -7) {
            return new ScalarTypeBoolean.BitBoolean();
        }
        if (booleanDbType == 4) {
            return new ScalarTypeBoolean.IntBoolean(1, (Integer)0);
        }
        if (booleanDbType == 12) {
            return new ScalarTypeBoolean.StringBoolean("T", "F");
        }
        return new ScalarTypeBoolean.Native();
    }

    public ScalarType<Date> createUtilDate(JsonConfig.DateTime mode, JsonConfig.Date jsonDate) {
        return this.createUtilDate(mode, jsonDate, 93);
    }

    public ScalarType<Date> createUtilDate(JsonConfig.DateTime jsonDateTime, JsonConfig.Date jsonDate, int utilDateType) {
        switch (utilDateType) {
            case 91: {
                return new ScalarTypeUtilDate.DateType(jsonDate);
            }
            case 93: {
                return new ScalarTypeUtilDate.TimestampType(jsonDateTime);
            }
        }
        throw new RuntimeException("Invalid type " + utilDateType);
    }

    public ScalarType<Calendar> createCalendar(JsonConfig.DateTime mode) {
        return this.createCalendar(mode, 93);
    }

    public ScalarType<Calendar> createCalendar(JsonConfig.DateTime mode, int jdbcType) {
        return new ScalarTypeCalendar(mode, jdbcType);
    }

    public ScalarType<BigInteger> createMathBigInteger() {
        return new ScalarTypeMathBigInteger();
    }
}

