/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.annotation.DocStoreMode;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.transaction.BeanPersistIds;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import io.ebeanservice.docstore.api.support.DocStoreDeleteEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DeleteByIdMap {
    private final Map<String, BeanPersistIds> beanMap = new LinkedHashMap<String, BeanPersistIds>();

    public String toString() {
        return "DeleteById " + this.beanMap.values();
    }

    public void notifyCache(CacheChangeSet changeSet) {
        for (BeanPersistIds deleteIds : this.beanMap.values()) {
            BeanDescriptor<?> d = deleteIds.getBeanDescriptor();
            List<Object> idValues = deleteIds.getIds();
            if (idValues == null) continue;
            d.cachePersistDeleteByIds(idValues, changeSet);
        }
    }

    public boolean isEmpty() {
        return this.beanMap.isEmpty();
    }

    public Collection<BeanPersistIds> values() {
        return this.beanMap.values();
    }

    public void add(BeanDescriptor<?> desc, Object id) {
        BeanPersistIds r = this.getPersistIds(desc);
        r.addId(PersistRequest.Type.DELETE, id);
    }

    public void addList(BeanDescriptor<?> desc, List<Object> idList) {
        BeanPersistIds r = this.getPersistIds(desc);
        for (Object idValue : idList) {
            r.addId(PersistRequest.Type.DELETE, idValue);
        }
    }

    private BeanPersistIds getPersistIds(BeanDescriptor<?> desc) {
        String beanType = desc.fullName();
        return this.beanMap.computeIfAbsent(beanType, k -> new BeanPersistIds(desc));
    }

    void addDocStoreUpdates(DocStoreUpdates docStoreUpdates, DocStoreMode txnIndexMode) {
        for (BeanPersistIds deleteIds : this.beanMap.values()) {
            BeanDescriptor<?> desc = deleteIds.getBeanDescriptor();
            DocStoreMode mode = desc.docStoreMode(PersistRequest.Type.DELETE, txnIndexMode);
            if (DocStoreMode.IGNORE == mode) continue;
            boolean queue = DocStoreMode.QUEUE == mode;
            String queueId = desc.docStoreQueueId();
            List<Object> idValues = deleteIds.getIds();
            if (idValues == null) continue;
            for (Object idValue : idValues) {
                if (queue) {
                    docStoreUpdates.queueDelete(queueId, idValue);
                    continue;
                }
                docStoreUpdates.addDelete(new DocStoreDeleteEvent(desc, idValue));
            }
        }
    }
}

