/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebean.config.dbplatform.DbEncrypt;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.persist.dml.DeleteMeta;
import io.ebeaninternal.server.persist.dml.DmlMode;
import io.ebeaninternal.server.persist.dml.InsertMeta;
import io.ebeaninternal.server.persist.dml.UpdateMeta;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import io.ebeaninternal.server.persist.dmlbind.BindableId;
import io.ebeaninternal.server.persist.dmlbind.BindableList;
import io.ebeaninternal.server.persist.dmlbind.BindableOrderColumn;
import io.ebeaninternal.server.persist.dmlbind.BindableUnidirectional;
import io.ebeaninternal.server.persist.dmlbind.FactoryAssocOnes;
import io.ebeaninternal.server.persist.dmlbind.FactoryBaseProperties;
import io.ebeaninternal.server.persist.dmlbind.FactoryEmbedded;
import io.ebeaninternal.server.persist.dmlbind.FactoryId;
import io.ebeaninternal.server.persist.dmlbind.FactoryVersion;
import java.util.ArrayList;

final class MetaFactory {
    private static final boolean includeLobs = true;
    private final FactoryBaseProperties baseFact;
    private final FactoryEmbedded embeddedFact;
    private final FactoryVersion versionFact = new FactoryVersion();
    private final FactoryAssocOnes assocOneFact = new FactoryAssocOnes();
    private final FactoryId idFact = new FactoryId();
    private final DatabasePlatform dbPlatform;

    MetaFactory(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
        DbEncrypt dbEncrypt = dbPlatform.dbEncrypt();
        boolean bindEncryptDataFirst = dbEncrypt == null || dbEncrypt.isBindEncryptDataFirst();
        this.baseFact = new FactoryBaseProperties(bindEncryptDataFirst);
        this.embeddedFact = new FactoryEmbedded(bindEncryptDataFirst);
    }

    UpdateMeta createUpdate(BeanDescriptor<?> desc) {
        ArrayList<Bindable> setList = new ArrayList<Bindable>();
        this.baseFact.create(setList, desc, DmlMode.UPDATE, true);
        this.embeddedFact.create(setList, desc, DmlMode.UPDATE, true);
        this.assocOneFact.create(setList, desc, DmlMode.UPDATE);
        BeanProperty orderColumn = desc.orderColumn();
        if (orderColumn != null) {
            setList.add(new BindableOrderColumn(orderColumn));
        }
        BindableId id = this.idFact.createId(desc);
        Bindable version = this.versionFact.create(desc);
        Bindable tenantId = this.versionFact.createTenantId(desc);
        BindableList setBindable = new BindableList(setList);
        return new UpdateMeta(setBindable, id, version, tenantId);
    }

    DeleteMeta createDelete(BeanDescriptor<?> desc) {
        BindableId id = this.idFact.createId(desc);
        Bindable version = this.versionFact.createForDelete(desc);
        Bindable tenantId = this.versionFact.createTenantId(desc);
        return new DeleteMeta(desc, id, version, tenantId);
    }

    InsertMeta createInsert(BeanDescriptor<?> desc) {
        BindableId id = this.idFact.createId(desc);
        ArrayList<Bindable> allList = new ArrayList<Bindable>();
        this.baseFact.create(allList, desc, DmlMode.INSERT, true);
        this.embeddedFact.create(allList, desc, DmlMode.INSERT, true);
        this.assocOneFact.create(allList, desc, DmlMode.INSERT);
        BindableList allBindable = new BindableList(allList);
        BeanPropertyAssocOne<?> unidirectional = desc.unidirectional();
        BindableUnidirectional shadowFkey = unidirectional == null ? null : new BindableUnidirectional(desc, unidirectional);
        return new InsertMeta(this.dbPlatform, desc, shadowFkey, id, allBindable);
    }
}

