/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.ebeaninternal.api.CoreLog;
import io.ebeaninternal.server.executor.DaemonThreadFactory;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;

public final class DaemonScheduleThreadPool
extends ScheduledThreadPoolExecutor {
    private static final System.Logger log = CoreLog.log;
    private final ReentrantLock lock = new ReentrantLock();
    private final String namePrefix;
    private final int shutdownWaitSeconds;

    public DaemonScheduleThreadPool(int coreSize, int shutdownWaitSeconds, String namePrefix) {
        super(coreSize, new DaemonThreadFactory(namePrefix));
        this.namePrefix = namePrefix;
        this.shutdownWaitSeconds = shutdownWaitSeconds;
    }

    @Override
    public void shutdown() {
        this.lock.lock();
        try {
            if (super.isShutdown()) {
                log.log(System.Logger.Level.DEBUG, "Already shutdown threadPool {0}", this.namePrefix);
                return;
            }
            try {
                log.log(System.Logger.Level.TRACE, "shutting down threadPool {0}", this.namePrefix);
                super.shutdown();
                if (!super.awaitTermination(this.shutdownWaitSeconds, TimeUnit.SECONDS)) {
                    log.log(System.Logger.Level.INFO, "Shutdown wait timeout exceeded. Terminating running threads for {0}", this.namePrefix);
                    super.shutdownNow();
                }
                log.log(System.Logger.Level.TRACE, "shutdown complete for threadPool {0}", this.namePrefix);
            }
            catch (Exception e) {
                log.log(System.Logger.Level.ERROR, "Error during shutdown of threadPool " + this.namePrefix, (Throwable)e);
                e.printStackTrace();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

