/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebean.meta.AbstractMetricVisitor;
import io.ebean.meta.BasicMetricVisitor;
import io.ebean.meta.MetaCountMetric;
import io.ebean.meta.MetaInfoManager;
import io.ebean.meta.MetaQueryMetric;
import io.ebean.meta.MetaQueryPlan;
import io.ebean.meta.MetaTimedMetric;
import io.ebean.meta.MetricNamingMatch;
import io.ebean.meta.MetricVisitor;
import io.ebean.meta.QueryPlanInit;
import io.ebean.meta.QueryPlanRequest;
import io.ebean.meta.ServerMetrics;
import io.ebeaninternal.server.core.DefaultServer;
import java.util.List;
import java.util.function.Function;

final class DefaultMetaInfoManager
implements MetaInfoManager {
    private final DefaultServer server;
    private final Function<String, String> naming;

    DefaultMetaInfoManager(DefaultServer server, Function<String, String> naming) {
        this.server = server;
        this.naming = naming;
    }

    public List<MetaQueryPlan> queryPlanInit(QueryPlanInit initRequest) {
        return this.server.queryPlanInit(initRequest);
    }

    public List<MetaQueryPlan> queryPlanCollectNow(QueryPlanRequest request) {
        return this.server.queryPlanCollectNow(request);
    }

    public void visitMetrics(MetricVisitor visitor) {
        this.server.visitMetrics(visitor);
    }

    public ServerMetrics collectMetrics() {
        return this.visitBasic();
    }

    public BasicMetricVisitor visitBasic() {
        BasicMetricVisitor basic = new BasicMetricVisitor(this.server.name(), this.naming);
        this.visitMetrics((MetricVisitor)basic);
        return basic;
    }

    public void resetAllMetrics() {
        this.server.visitMetrics((MetricVisitor)new ResetVisitor());
    }

    private static class ResetVisitor
    extends AbstractMetricVisitor {
        ResetVisitor() {
            super(true, true, true, true);
        }

        public Function<String, String> namingConvention() {
            return MetricNamingMatch.INSTANCE;
        }

        public void visitTimed(MetaTimedMetric metric) {
        }

        public void visitQuery(MetaQueryMetric metric) {
        }

        public void visitCount(MetaCountMetric metric) {
        }
    }
}

