/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cluster;

import io.avaje.applog.AppLog;
import io.ebean.Database;
import io.ebean.config.ContainerConfig;
import io.ebeaninternal.server.cluster.ClusterBroadcast;
import io.ebeaninternal.server.cluster.ClusterBroadcastFactory;
import io.ebeaninternal.server.cluster.ServerLookup;
import io.ebeaninternal.server.transaction.RemoteTransactionEvent;
import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantLock;

public class ClusterManager
implements ServerLookup {
    private static final System.Logger clusterLogger = AppLog.getLogger((String)"io.ebean.Cluster");
    private final ReentrantLock lock = new ReentrantLock();
    private final ConcurrentHashMap<String, Database> serverMap = new ConcurrentHashMap();
    private final Object monitor = new Object();
    private final ClusterBroadcast broadcast;
    private boolean started;
    private boolean shutdown;

    public ClusterManager(ContainerConfig config) {
        ClusterBroadcastFactory factory = this.createFactory();
        this.broadcast = factory != null && config.isActive() ? factory.create(this, config) : null;
    }

    private ClusterBroadcastFactory createFactory() {
        ServiceLoader<ClusterBroadcastFactory> load = ServiceLoader.load(ClusterBroadcastFactory.class);
        ClusterBroadcastFactory factory = null;
        Iterator<ClusterBroadcastFactory> iterator = load.iterator();
        if (iterator.hasNext()) {
            factory = iterator.next();
        }
        return factory;
    }

    public void registerServer(Database server) {
        this.lock.lock();
        try {
            this.serverMap.put(server.name(), server);
            if (!this.started) {
                this.startup();
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public Database getServer(String name) {
        this.lock.lock();
        try {
            Database database = this.serverMap.get(name);
            return database;
        }
        finally {
            this.lock.unlock();
        }
    }

    private void startup() {
        this.started = true;
        if (this.broadcast != null) {
            this.broadcast.startup();
        }
    }

    public void cacheClearAll(String serverName) {
        if (this.broadcast != null) {
            this.broadcast.broadcast(new RemoteTransactionEvent(serverName).cacheClearAll());
        }
    }

    public void cacheClear(String serverName, Class<?> beanType) {
        if (this.broadcast != null) {
            this.broadcast.broadcast(new RemoteTransactionEvent(serverName).cacheClear(beanType));
        }
    }

    public boolean isClustering() {
        return this.broadcast != null;
    }

    public void broadcast(RemoteTransactionEvent event) {
        if (this.broadcast != null) {
            if (clusterLogger.isLoggable(System.Logger.Level.DEBUG)) {
                clusterLogger.log(System.Logger.Level.DEBUG, "sending: {0}", event);
            }
            this.broadcast.broadcast(event);
        }
    }

    public void shutdown() {
        if (this.broadcast != null && !this.shutdown) {
            this.shutdown = true;
            this.broadcast.shutdown();
        }
    }
}

