/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.cache;

import io.avaje.applog.AppLog;
import io.ebean.cache.ServerCache;
import io.ebean.cache.ServerCacheRegion;
import io.ebean.cache.ServerCacheType;
import io.ebean.meta.MetricVisitor;
import io.ebeaninternal.api.SpiCacheRegion;
import io.ebeaninternal.server.cache.CacheManagerOptions;
import io.ebeaninternal.server.cache.DefaultCacheHolder;
import io.ebeaninternal.server.cache.SpiCacheManager;
import io.ebeaninternal.server.cluster.ClusterManager;
import io.ebeaninternal.server.deploy.DCacheRegion;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class DefaultServerCacheManager
implements SpiCacheManager {
    private static final System.Logger log = AppLog.getLogger((String)"io.ebean.cache.REGION");
    private final Map<String, SpiCacheRegion> regionMap = new HashMap<String, SpiCacheRegion>();
    private final ClusterManager clusterManager;
    private final DefaultCacheHolder cacheHolder;
    private final boolean localL2Caching;
    private final String serverName;

    public DefaultServerCacheManager(CacheManagerOptions builder) {
        this.clusterManager = builder.getClusterManager();
        this.serverName = builder.getServerName();
        this.localL2Caching = builder.isLocalL2Caching();
        this.cacheHolder = new DefaultCacheHolder(builder);
    }

    public DefaultServerCacheManager() {
        this(new CacheManagerOptions());
    }

    @Override
    public boolean isLocalL2Caching() {
        return this.localL2Caching;
    }

    @Override
    public List<ServerCacheRegion> allRegions() {
        return new ArrayList<ServerCacheRegion>(this.regionMap.values());
    }

    @Override
    public void setEnabledRegions(String regions) {
        if (regions != null) {
            List<String> enabledRegionNames = Arrays.asList(regions.split(","));
            ArrayList<String> disabled = new ArrayList<String>();
            ArrayList<String> enabled = new ArrayList<String>();
            for (SpiCacheRegion region : this.regionMap.values()) {
                if (enabledRegionNames.contains(region.name())) {
                    enabled.add(region.name());
                    if (region.isEnabled()) continue;
                    region.setEnabled(true);
                    log.log(System.Logger.Level.DEBUG, "Cache region[{0}] enabled", region.name());
                    continue;
                }
                disabled.add(region.name());
                if (!region.isEnabled()) continue;
                region.setEnabled(false);
                log.log(System.Logger.Level.DEBUG, "Cache region[{0}] disabled", region.name());
            }
            log.log(System.Logger.Level.INFO, "Cache regions enabled:{0} disabled:{1}", enabled, disabled);
        }
    }

    @Override
    public void setAllRegionsEnabled(boolean enabled) {
        log.log(System.Logger.Level.DEBUG, "All cache regions enabled[{0}]", enabled);
        for (SpiCacheRegion region : this.regionMap.values()) {
            region.setEnabled(enabled);
        }
    }

    @Override
    public SpiCacheRegion getRegion(String region) {
        return this.regionMap.computeIfAbsent(region, DCacheRegion::new);
    }

    @Override
    public void visitMetrics(MetricVisitor visitor) {
        this.cacheHolder.visitMetrics(visitor);
    }

    @Override
    public void clearAll() {
        this.cacheHolder.clearAll();
        if (this.clusterManager != null) {
            this.clusterManager.cacheClearAll(this.serverName);
        }
    }

    @Override
    public void clearAllLocal() {
        this.cacheHolder.clearAll();
    }

    @Override
    public void clear(Class<?> beanType) {
        this.cacheHolder.clear(beanType.getName());
        if (this.clusterManager != null) {
            this.clusterManager.cacheClear(this.serverName, beanType);
        }
    }

    @Override
    public void clearLocal(Class<?> beanType) {
        this.cacheHolder.clear(beanType.getName());
    }

    @Override
    public ServerCache getCollectionIdsCache(Class<?> beanType, String collectionProperty) {
        return this.cacheHolder.getCache(beanType, collectionProperty);
    }

    @Override
    public ServerCache getNaturalKeyCache(Class<?> beanType) {
        return this.cacheHolder.getCache(beanType, ServerCacheType.NATURAL_KEY);
    }

    @Override
    public ServerCache getQueryCache(Class<?> beanType) {
        return this.cacheHolder.getCache(beanType, ServerCacheType.QUERY);
    }

    @Override
    public ServerCache getBeanCache(Class<?> beanType) {
        return this.cacheHolder.getCache(beanType, ServerCacheType.BEAN);
    }
}

