/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DataReader;
import io.ebean.core.type.DocPropertyType;
import io.ebean.text.TextException;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

abstract class ScalarTypeBaseVarchar<T>
extends ScalarTypeBase<T> {
    ScalarTypeBaseVarchar(Class<T> type) {
        super(type, false, 12);
    }

    ScalarTypeBaseVarchar(Class<T> type, boolean jdbcNative, int jdbcType) {
        super(type, jdbcNative, jdbcType);
    }

    public abstract String formatValue(T var1);

    public abstract T parse(String var1);

    public abstract T convertFromDbString(String var1);

    public abstract String convertToDbString(T var1);

    public void bind(DataBinder binder, T value) throws SQLException {
        if (value == null) {
            binder.setNull(12);
        } else {
            binder.setString(this.convertToDbString(value));
        }
    }

    public T read(DataReader reader) throws SQLException {
        String s = reader.getString();
        if (s == null) {
            return null;
        }
        return this.convertFromDbString(s);
    }

    public T toBeanType(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return this.parse((String)value);
        }
        return (T)value;
    }

    public Object toJdbcType(Object value) {
        if (value instanceof String) {
            return value;
        }
        return this.format(value);
    }

    public T convertFromMillis(long systemTimeMillis) {
        throw new TextException("Not Supported");
    }

    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public String format(Object value) {
        return this.formatValue(value);
    }

    public T readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.convertFromDbString(dataInput.readUTF());
    }

    public void writeData(DataOutput dataOutput, T value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.convertToDbString(value));
        }
    }

    public T jsonRead(JsonParser parser) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    public void jsonWrite(JsonGenerator writer, T value) throws IOException {
        writer.writeString(this.format(value));
    }

    public DocPropertyType getDocType() {
        return DocPropertyType.TEXT;
    }
}

