/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.core.type.DataBinder;
import io.ebean.core.type.DocPropertyType;
import io.ebean.core.type.ScalarType;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.json.ModifyAwareList;
import io.ebeaninternal.server.type.ArrayElementConverter;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeArrayBase;
import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;

class ScalarTypeArrayList
extends ScalarTypeArrayBase<List>
implements ScalarTypeArray {
    private final String arrayType;
    private final ArrayElementConverter converter;

    static PlatformArrayTypeFactory factory() {
        return new Factory();
    }

    public ScalarTypeArrayList(boolean nullable, String arrayType, DocPropertyType docPropertyType, ArrayElementConverter converter) {
        super(List.class, 2003, docPropertyType, nullable);
        this.arrayType = arrayType;
        this.converter = converter;
    }

    @Override
    public DocPropertyType getDocType() {
        return this.docPropertyType;
    }

    @Override
    public String getDbColumnDefn() {
        return this.arrayType + "[]";
    }

    @Override
    protected List fromArray(Object[] array1) {
        ArrayList list = new ArrayList(array1.length);
        for (Object element : array1) {
            if (element == null) {
                list.add(null);
                continue;
            }
            list.add(this.converter.fromDbArray(element));
        }
        return new ModifyAwareList(list);
    }

    protected Object[] toArray(List value) {
        return this.converter.toDbArray(value.toArray());
    }

    public void bind(DataBinder binder, List value) throws SQLException {
        if (value == null) {
            this.bindNull(binder);
        } else {
            binder.setArray(this.arrayType, this.toArray(value));
        }
    }

    @Override
    protected void bindNull(DataBinder binder) throws SQLException {
        if (this.nullable) {
            binder.setNull(2003);
        } else {
            binder.setArray(this.arrayType, this.toArray(Collections.EMPTY_LIST));
        }
    }

    public String formatValue(List value) {
        try {
            return EJson.write((Object)value);
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
        }
    }

    public List parse(String value) {
        try {
            return this.convert(EJson.parseList((String)value, (boolean)false));
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as List", value, (Exception)e);
        }
    }

    private List convert(List<Object> rawList) {
        ArrayList list = new ArrayList(rawList.size());
        for (Object rawVal : rawList) {
            list.add(this.converter.fromSerialized(rawVal));
        }
        return new ModifyAwareList(list);
    }

    public List jsonRead(JsonParser parser) throws IOException {
        return this.convert(EJson.parseList((JsonParser)parser, (JsonToken)parser.getCurrentToken()));
    }

    public void jsonWrite(JsonGenerator writer, List value) throws IOException {
        EJson.write((Object)value, (JsonGenerator)writer);
    }

    static class Factory
    implements PlatformArrayTypeFactory {
        private final ReentrantLock lock = new ReentrantLock();
        private final Map<String, ScalarTypeArrayList> cache = new HashMap<String, ScalarTypeArrayList>();

        Factory() {
        }

        public ScalarTypeArrayList typeFor(Type valueType, boolean nullable) {
            this.lock.lock();
            try {
                String key = valueType + ":" + nullable;
                if (valueType.equals(UUID.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "uuid", DocPropertyType.UUID, ArrayElementConverter.UUID));
                    return scalarTypeArrayList;
                }
                if (valueType.equals(Long.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "bigint", DocPropertyType.LONG, ArrayElementConverter.LONG));
                    return scalarTypeArrayList;
                }
                if (valueType.equals(Integer.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "integer", DocPropertyType.INTEGER, ArrayElementConverter.INTEGER));
                    return scalarTypeArrayList;
                }
                if (valueType.equals(Double.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "float", DocPropertyType.DOUBLE, ArrayElementConverter.DOUBLE));
                    return scalarTypeArrayList;
                }
                if (valueType.equals(BigDecimal.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "decimal", DocPropertyType.DOUBLE, ArrayElementConverter.BIG_DECIMAL));
                    return scalarTypeArrayList;
                }
                if (valueType.equals(String.class)) {
                    ScalarTypeArrayList scalarTypeArrayList = this.cache.computeIfAbsent(key, s -> new ScalarTypeArrayList(nullable, "varchar", DocPropertyType.TEXT, ArrayElementConverter.STRING));
                    return scalarTypeArrayList;
                }
                throw new IllegalArgumentException("Type [" + valueType + "] not supported for @DbArray mapping");
            }
            finally {
                this.lock.unlock();
            }
        }

        public ScalarTypeArrayList typeForEnum(ScalarType<?> scalarType, boolean nullable) {
            return new ScalarTypeArrayList(nullable, ScalarTypeArrayBase.arrayTypeFor(scalarType), scalarType.getDocType(), new ArrayElementConverter.EnumConverter(scalarType));
        }
    }
}

