/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebean.ProfileLocation;

public final class TransactionProfile {
    private final ProfileLocation location;
    private final String label;
    private final long startTime;
    private long totalMicros;
    private String data;
    private Summary summary;

    public TransactionProfile(long startTime, ProfileLocation location) {
        this.location = location;
        this.label = location.label();
        this.startTime = startTime;
        this.summary = new Summary();
    }

    public String getLabel() {
        return this.label;
    }

    public long getStartTime() {
        return this.startTime;
    }

    public long getTotalMicros() {
        return this.totalMicros;
    }

    public String getData() {
        return this.data;
    }

    public void setTotalMicros(long totalMicros) {
        this.totalMicros = totalMicros;
    }

    public void setData(String data) {
        this.data = data;
    }

    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public static class Summary {
        public long queryMicros;
        public long queryCount;
        public long queryBeans;
        public long queryMax;
        public long persistMicros;
        public long persistCount;
        public long persistBeans;
        public long persistOneCount;
        public long commitMicros;

        void addPersist(long micros, int beanCount) {
            this.persistMicros += micros;
            this.persistBeans += (long)beanCount;
            ++this.persistCount;
            if (beanCount == 1) {
                ++this.persistOneCount;
            }
        }

        void addQuery(long micros, int beanCount) {
            this.queryMax = Math.max(this.queryMax, micros);
            this.queryMicros += micros;
            this.queryBeans += (long)beanCount;
            ++this.queryCount;
        }
    }
}

