/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.core.type.ScalarDataReader;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.id.IdBinder;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.STreePropertyAssoc;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.STreePropertyAssocOne;
import io.ebeaninternal.server.query.STreeType;
import io.ebeaninternal.server.query.SqlBeanLoad;
import io.ebeaninternal.server.query.SqlTreeLoad;
import io.ebeaninternal.server.query.SqlTreeNodeBean;
import java.sql.SQLException;
import java.util.Map;

class SqlTreeLoadBean
implements SqlTreeLoad {
    final STreeType desc;
    final IdBinder idBinder;
    final SqlTreeLoad[] children;
    private final boolean partialObject;
    private final STreeProperty[] properties;
    private final STreePropertyAssoc nodeBeanProp;
    final boolean readId;
    private final boolean readIdNormal;
    private final boolean disableLazyLoad;
    private final boolean readOnlyNoIntercept;
    private final InheritInfo inheritInfo;
    final String prefix;
    private final Map<String, String> pathMap;
    final STreePropertyAssocMany lazyLoadParent;
    private final SpiQuery.TemporalMode temporalMode;
    private final boolean temporalVersions;
    final IdBinder lazyLoadParentIdBinder;

    SqlTreeLoadBean(SqlTreeNodeBean node) {
        this.lazyLoadParent = node.lazyLoadParent;
        this.lazyLoadParentIdBinder = node.lazyLoadParentIdBinder;
        this.prefix = node.prefix;
        this.desc = node.desc;
        this.inheritInfo = this.desc.inheritInfo();
        this.idBinder = this.desc.idBinder();
        this.temporalMode = node.temporalMode;
        this.temporalVersions = node.temporalVersions;
        this.nodeBeanProp = node.nodeBeanProp;
        this.readId = node.readId;
        this.readIdNormal = this.readId && !this.temporalVersions;
        this.disableLazyLoad = node.disableLazyLoad;
        this.readOnlyNoIntercept = this.disableLazyLoad && node.readOnly;
        this.partialObject = node.partialObject;
        this.properties = node.properties;
        this.pathMap = node.pathMap;
        this.children = node.createLoadChildren();
    }

    boolean isRoot() {
        return false;
    }

    @Override
    public final ScalarDataReader<?> getSingleAttributeReader() {
        STreePropertyAssocOne assocOne;
        if (this.properties == null || this.properties.length == 0) {
            if (this.children.length == 0) {
                return this.desc.idBinder().getBeanProperty();
            }
            return this.children[0].getSingleAttributeReader();
        }
        if (this.properties[0] instanceof STreePropertyAssocOne && (assocOne = (STreePropertyAssocOne)this.properties[0]).isAssocId()) {
            return assocOne.idReader();
        }
        return this.properties[0];
    }

    @Override
    public EntityBean load(DbReadContext ctx, EntityBean parentBean, EntityBean contextParent) throws SQLException {
        return this.createLoad(ctx, parentBean).perform();
    }

    final Load createLoad(DbReadContext ctx, EntityBean parentBean) {
        return this.inheritInfo != null ? new LoadInherit(ctx, parentBean) : new Load(ctx, parentBean);
    }

    public String toString() {
        return "SqlTreeLoadBean: " + this.desc;
    }

    class Load {
        final DbReadContext ctx;
        final EntityBean parentBean;
        Object lazyLoadParentId;
        Class<?> localType;
        STreeType localDesc;
        IdBinder localIdBinder;
        EntityBean localBean;
        SpiQuery.Mode queryMode;
        PersistenceContext persistenceContext;
        Object id;
        EntityBean contextBean;
        SqlBeanLoad sqlBeanLoad;
        boolean lazyLoadMany;

        private Load(DbReadContext ctx, EntityBean parentBean) {
            this.ctx = ctx;
            this.parentBean = parentBean;
        }

        private void initLazyParent() throws SQLException {
            if (SqlTreeLoadBean.this.lazyLoadParentIdBinder != null) {
                this.lazyLoadParentId = SqlTreeLoadBean.this.lazyLoadParentIdBinder.read(this.ctx);
            }
        }

        void initBeanType() throws SQLException {
            this.localDesc = SqlTreeLoadBean.this.desc;
            this.localBean = SqlTreeLoadBean.this.desc.createEntityBean2(SqlTreeLoadBean.this.readOnlyNoIntercept);
            this.localIdBinder = SqlTreeLoadBean.this.idBinder;
        }

        private void initPersistenceContext() {
            this.queryMode = this.ctx.getQueryMode();
            this.persistenceContext = !SqlTreeLoadBean.this.readIdNormal ? null : this.ctx.getPersistenceContext();
        }

        private void readId() throws SQLException {
            if (SqlTreeLoadBean.this.readId) {
                this.id = this.localIdBinder.readSet(this.ctx, this.localBean);
                if (this.id == null) {
                    this.readIdNullBean();
                } else if (!SqlTreeLoadBean.this.temporalVersions) {
                    this.readIdBean();
                }
            }
        }

        private void readIdBean() {
            this.contextBean = (EntityBean)this.localDesc.contextPutIfAbsent(this.persistenceContext, this.id, this.localBean);
            if (this.contextBean == null) {
                this.contextBean = this.localBean;
            } else if (this.queryMode.isLoadContextBean()) {
                this.localBean = this.contextBean;
            } else if (!this.contextBean._ebean_getIntercept().isFullyLoadedBean()) {
                this.localBean = this.contextBean;
                this.queryMode = SpiQuery.Mode.LAZYLOAD_BEAN;
            } else {
                this.localBean = null;
            }
        }

        private void readIdNullBean() {
            this.localBean = null;
            if (this.parentBean != null && SqlTreeLoadBean.this.nodeBeanProp instanceof STreePropertyAssocOne) {
                this.contextBean = ((STreePropertyAssocOne)SqlTreeLoadBean.this.nodeBeanProp).getValueAsEntityBean(this.parentBean);
                if (this.contextBean != null) {
                    SqlTreeLoadBean.this.desc.markAsDeleted(this.contextBean);
                }
            }
        }

        private void initSqlLoadBean() {
            this.ctx.setCurrentPrefix(SqlTreeLoadBean.this.prefix, SqlTreeLoadBean.this.pathMap);
            this.ctx.propagateState(this.localBean);
            this.sqlBeanLoad = new SqlBeanLoad(this.ctx, this.localType, this.localBean, this.queryMode);
        }

        void loadProperties() {
            for (STreeProperty property : SqlTreeLoadBean.this.properties) {
                property.load(this.sqlBeanLoad);
            }
        }

        private void loadChildren() throws SQLException {
            if (this.localBean == null && this.queryMode == SpiQuery.Mode.LAZYLOAD_MANY) {
                this.localBean = this.contextBean;
                this.lazyLoadMany = true;
            }
            for (SqlTreeLoad child : SqlTreeLoadBean.this.children) {
                child.load(this.ctx, this.localBean, this.contextBean);
            }
        }

        private boolean isLazyLoadManyRoot() {
            return this.queryMode == SpiQuery.Mode.LAZYLOAD_MANY && SqlTreeLoadBean.this.isRoot();
        }

        private EntityBean getContextBean() {
            return this.contextBean;
        }

        private void postLoad() {
            if (!this.lazyLoadMany && this.localBean != null) {
                this.ctx.setCurrentPrefix(SqlTreeLoadBean.this.prefix, SqlTreeLoadBean.this.pathMap);
                if (SqlTreeLoadBean.this.readIdNormal) {
                    this.createListProxies();
                }
                if (SqlTreeLoadBean.this.temporalMode == SpiQuery.TemporalMode.DRAFT) {
                    this.localDesc.setDraft(this.localBean);
                }
                this.localDesc.postLoad(this.localBean);
                EntityBeanIntercept ebi = this.localBean._ebean_getIntercept();
                ebi.setPersistenceContext(this.persistenceContext);
                if (SpiQuery.Mode.LAZYLOAD_BEAN == this.queryMode) {
                    ebi.setLoadedLazy();
                } else if (SqlTreeLoadBean.this.readId) {
                    ebi.setLoaded();
                }
                if (SqlTreeLoadBean.this.disableLazyLoad) {
                    ebi.setDisableLazyLoad(true);
                } else if (SqlTreeLoadBean.this.partialObject) {
                    if (SqlTreeLoadBean.this.readId) {
                        this.ctx.register(null, ebi);
                    }
                } else {
                    ebi.setFullyLoadedBean(true);
                }
                if (this.ctx.isAutoTuneProfiling() && !SqlTreeLoadBean.this.disableLazyLoad) {
                    this.ctx.profileBean(ebi, SqlTreeLoadBean.this.prefix);
                }
            }
        }

        private void createListProxies() {
            STreePropertyAssocMany fetchedMany = this.ctx.getManyProperty();
            boolean forceNewReference = this.queryMode == SpiQuery.Mode.REFRESH_BEAN;
            for (STreePropertyAssocMany many : this.localDesc.propsMany()) {
                if (many == fetchedMany) continue;
                if (SqlTreeLoadBean.this.readOnlyNoIntercept) {
                    many.createEmptyReference(this.localBean);
                    continue;
                }
                BeanCollection<?> ref = many.createReference(this.localBean, forceNewReference);
                if (ref == null) continue;
                if (SqlTreeLoadBean.this.disableLazyLoad) {
                    ref.setDisableLazyLoad(true);
                }
                if (ref.isRegisteredWithLoadContext()) continue;
                this.ctx.register(many.asMany(), ref);
            }
        }

        private void setBeanToParent() {
            if (this.parentBean != null) {
                SqlTreeLoadBean.this.nodeBeanProp.setValue(this.parentBean, this.contextBean);
            }
        }

        private EntityBean complete() {
            if (!SqlTreeLoadBean.this.readIdNormal) {
                if (this.lazyLoadParentId != null) {
                    this.ctx.setLazyLoadedChildBean(this.localBean, this.lazyLoadParentId);
                }
                return this.localBean;
            }
            if (this.lazyLoadParentId != null) {
                this.ctx.setLazyLoadedChildBean(this.contextBean, this.lazyLoadParentId);
            }
            return this.contextBean;
        }

        private void initialise() throws SQLException {
            this.initLazyParent();
            this.initBeanType();
            this.initPersistenceContext();
            this.readId();
            this.initSqlLoadBean();
            this.loadProperties();
            this.loadChildren();
        }

        final EntityBean perform() throws SQLException {
            this.initialise();
            if (this.isLazyLoadManyRoot()) {
                return this.getContextBean();
            }
            this.postLoad();
            this.setBeanToParent();
            return this.complete();
        }

        final boolean isContextBean() {
            return this.localBean == null;
        }
    }

    private final class LoadInherit
    extends Load {
        private LoadInherit(DbReadContext ctx, EntityBean parentBean) {
            super(ctx, parentBean);
        }

        @Override
        void initBeanType() throws SQLException {
            InheritInfo localInfo;
            InheritInfo inheritInfo = localInfo = SqlTreeLoadBean.this.readId ? SqlTreeLoadBean.this.inheritInfo.readType(this.ctx) : SqlTreeLoadBean.this.desc.inheritInfo();
            if (localInfo == null) {
                this.localIdBinder = SqlTreeLoadBean.this.idBinder;
                this.localDesc = SqlTreeLoadBean.this.desc;
            } else {
                this.localBean = localInfo.createEntityBean();
                this.localType = localInfo.getType();
                this.localIdBinder = localInfo.getIdBinder();
                this.localDesc = localInfo.desc();
            }
        }

        @Override
        void loadProperties() {
            for (STreeProperty property : SqlTreeLoadBean.this.properties) {
                this.localDesc.inheritanceLoad(this.sqlBeanLoad, property, this.ctx);
            }
        }
    }
}

