/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.config.dbplatform.DatabasePlatform;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.persist.BeanPersister;
import io.ebeaninternal.server.persist.BeanPersisterFactory;
import io.ebeaninternal.server.persist.dml.DeleteMeta;
import io.ebeaninternal.server.persist.dml.DmlBeanPersister;
import io.ebeaninternal.server.persist.dml.DocStoreBeanPersister;
import io.ebeaninternal.server.persist.dml.GeneratedProperties;
import io.ebeaninternal.server.persist.dml.InsertMeta;
import io.ebeaninternal.server.persist.dml.MetaFactory;
import io.ebeaninternal.server.persist.dml.UpdateMeta;

public final class DmlBeanPersisterFactory
implements BeanPersisterFactory {
    private final DatabasePlatform dbPlatform;
    private final MetaFactory metaFactory;

    public DmlBeanPersisterFactory(DatabasePlatform dbPlatform) {
        this.dbPlatform = dbPlatform;
        this.metaFactory = new MetaFactory(dbPlatform);
    }

    @Override
    public BeanPersister create(BeanDescriptor<?> desc) {
        if (desc.isDocStoreOnly()) {
            return new DocStoreBeanPersister(GeneratedProperties.of(desc));
        }
        UpdateMeta updMeta = this.metaFactory.createUpdate(desc);
        DeleteMeta delMeta = this.metaFactory.createDelete(desc);
        InsertMeta insMeta = this.metaFactory.createInsert(desc);
        return new DmlBeanPersister(this.dbPlatform, updMeta, insMeta, delMeta);
    }
}

