/*
 * Decompiled with CFR 0.152.
 */
package io.ebeanservice.docstore.api.support;

import io.ebean.FetchPath;
import io.ebean.Query;
import io.ebean.annotation.DocStore;
import io.ebean.annotation.DocStoreMode;
import io.ebean.docstore.DocUpdateContext;
import io.ebean.plugin.BeanType;
import io.ebean.text.PathProperties;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.InheritInfo;
import io.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import io.ebeanservice.docstore.api.DocStoreBeanAdapter;
import io.ebeanservice.docstore.api.DocStoreUpdateContext;
import io.ebeanservice.docstore.api.DocStoreUpdates;
import io.ebeanservice.docstore.api.mapping.DocMappingBuilder;
import io.ebeanservice.docstore.api.mapping.DocumentMapping;
import io.ebeanservice.docstore.api.support.DocStoreEmbeddedInvalidation;
import io.ebeanservice.docstore.api.support.DocStoreEmbeddedInvalidationProperties;
import io.ebeanservice.docstore.api.support.DocStructure;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class DocStoreBeanBaseAdapter<T>
implements DocStoreBeanAdapter<T> {
    protected final SpiEbeanServer server;
    protected final BeanDescriptor<T> desc;
    protected final boolean mapped;
    protected final String queueId;
    protected final String indexType;
    protected final String indexName;
    private final DocStore docStore;
    protected final DocStoreMode insert;
    protected DocStoreMode update;
    protected final DocStoreMode delete;
    protected final List<DocStoreEmbeddedInvalidation> embeddedInvalidation = new ArrayList<DocStoreEmbeddedInvalidation>();
    protected final PathProperties pathProps;
    protected Map<String, String> sortableMap;
    protected DocStructure docStructure;
    protected DocumentMapping documentMapping;
    private boolean registerPaths;

    public DocStoreBeanBaseAdapter(BeanDescriptor<T> desc, DeployBeanDescriptor<T> deploy) {
        this.desc = desc;
        this.server = desc.getEbeanServer();
        this.mapped = deploy.isDocStoreMapped();
        this.pathProps = deploy.getDocStorePathProperties();
        this.docStore = deploy.getDocStore();
        this.queueId = this.derive(desc, deploy.getDocStoreQueueId());
        this.indexName = this.derive(desc, deploy.getDocStoreIndexName());
        this.indexType = this.derive(desc, deploy.getDocStoreIndexType());
        this.insert = deploy.getDocStoreInsertEvent();
        this.update = deploy.getDocStoreUpdateEvent();
        this.delete = deploy.getDocStoreDeleteEvent();
    }

    @Override
    public boolean hasEmbeddedInvalidation() {
        return !this.embeddedInvalidation.isEmpty();
    }

    @Override
    public DocumentMapping createDocMapping() {
        if (this.documentMapping != null) {
            return this.documentMapping;
        }
        if (!this.mapped) {
            return null;
        }
        this.docStructure = this.derivePathProperties(this.pathProps);
        DocMappingBuilder mappingBuilder = new DocMappingBuilder(this.docStructure.doc(), this.docStore);
        this.desc.docStoreMapping(mappingBuilder, null);
        mappingBuilder.applyMapping();
        this.sortableMap = mappingBuilder.collectSortable();
        this.docStructure.prepareMany(this.desc);
        this.documentMapping = mappingBuilder.create(this.queueId, this.indexName, this.indexType);
        return this.documentMapping;
    }

    @Override
    public String getIndexType() {
        return this.indexType;
    }

    @Override
    public String getIndexName() {
        return this.indexName;
    }

    @Override
    public void applyPath(Query<T> query) {
        query.apply((FetchPath)this.docStructure.doc());
    }

    @Override
    public String rawProperty(String property) {
        String rawProperty = this.sortableMap.get(property);
        return rawProperty == null ? property : rawProperty;
    }

    @Override
    public void registerPaths() {
        if (this.mapped && !this.registerPaths) {
            Collection pathProps = this.docStructure.doc().getPathProps();
            for (PathProperties.Props pathProp : pathProps) {
                BeanDescriptor<?> targetDesc;
                BeanProperty idProperty;
                String path = pathProp.getPath();
                if (path == null || (idProperty = (targetDesc = this.desc.getBeanDescriptor(path)).getIdProperty()) == null) continue;
                String fullPath = path + "." + idProperty.getName();
                targetDesc.docStoreAdapter().registerInvalidationPath(this.desc.getDocStoreQueueId(), fullPath, pathProp.getProperties());
            }
            this.registerPaths = true;
        }
    }

    @Override
    public void registerInvalidationPath(String queueId, String path, Set<String> properties) {
        if (!this.mapped && this.update == DocStoreMode.IGNORE) {
            this.update = DocStoreMode.UPDATE;
        }
        this.embeddedInvalidation.add(this.getEmbeddedInvalidation(queueId, path, properties));
    }

    protected DocStoreEmbeddedInvalidation getEmbeddedInvalidation(String queueId, String path, Set<String> properties) {
        if (properties.contains("*")) {
            return new DocStoreEmbeddedInvalidation(queueId, path);
        }
        return new DocStoreEmbeddedInvalidationProperties(queueId, path, this.getPropertyPositions(properties));
    }

    protected int[] getPropertyPositions(Set<String> properties) {
        ArrayList<Integer> posList = new ArrayList<Integer>();
        for (String property : properties) {
            BeanProperty prop = this.desc.getBeanProperty(property);
            if (prop == null) continue;
            posList.add(prop.getPropertyIndex());
        }
        int[] pos = new int[posList.size()];
        for (int i = 0; i < pos.length; ++i) {
            pos[i] = (Integer)posList.get(i);
        }
        return pos;
    }

    @Override
    public void updateEmbedded(PersistRequestBean<T> request, DocStoreUpdates docStoreUpdates) {
        for (DocStoreEmbeddedInvalidation anEmbeddedInvalidation : this.embeddedInvalidation) {
            anEmbeddedInvalidation.embeddedInvalidate(request, docStoreUpdates);
        }
    }

    protected DocStructure derivePathProperties(PathProperties pathProps) {
        boolean includeByDefault;
        boolean bl = includeByDefault = pathProps == null;
        if (pathProps == null) {
            pathProps = new PathProperties();
        }
        return this.getDocStructure(pathProps, includeByDefault);
    }

    protected DocStructure getDocStructure(PathProperties pathProps, boolean includeByDefault) {
        BeanProperty[] properties;
        DocStructure docStructure = new DocStructure(pathProps);
        for (BeanProperty property : properties = this.desc.propertiesNonTransient()) {
            property.docStoreInclude(includeByDefault, docStructure);
        }
        InheritInfo inheritInfo = this.desc.getInheritInfo();
        if (inheritInfo != null) {
            inheritInfo.visitChildren(inheritInfo1 -> {
                for (BeanProperty localProperty : inheritInfo1.localProperties()) {
                    localProperty.docStoreInclude(includeByDefault, docStructure);
                }
            });
        }
        return docStructure;
    }

    public FetchPath getEmbedded(String path) {
        return this.docStructure.getEmbedded(path);
    }

    public FetchPath getEmbeddedManyRoot(String path) {
        return this.docStructure.getEmbeddedManyRoot(path);
    }

    @Override
    public boolean isMapped() {
        return this.mapped;
    }

    @Override
    public String getQueueId() {
        return this.queueId;
    }

    @Override
    public DocStoreMode getMode(PersistRequest.Type persistType, DocStoreMode txnMode) {
        if (txnMode == null) {
            return this.getMode(persistType);
        }
        if (txnMode == DocStoreMode.IGNORE) {
            return DocStoreMode.IGNORE;
        }
        return this.mapped ? txnMode : this.getMode(persistType);
    }

    private DocStoreMode getMode(PersistRequest.Type persistType) {
        switch (persistType) {
            case INSERT: {
                return this.insert;
            }
            case UPDATE: {
                return this.update;
            }
            case DELETE: {
                return this.delete;
            }
        }
        return DocStoreMode.IGNORE;
    }

    protected String derive(BeanType<?> desc, String suppliedValue) {
        return suppliedValue != null && !suppliedValue.isEmpty() ? suppliedValue : desc.getName().toLowerCase();
    }

    @Override
    public abstract void deleteById(Object var1, DocUpdateContext var2) throws IOException;

    @Override
    public abstract void index(Object var1, T var2, DocUpdateContext var3) throws IOException;

    @Override
    public abstract void insert(Object var1, PersistRequestBean<T> var2, DocStoreUpdateContext var3) throws IOException;

    @Override
    public abstract void update(Object var1, PersistRequestBean<T> var2, DocStoreUpdateContext var3) throws IOException;

    @Override
    public abstract void updateEmbedded(Object var1, String var2, String var3, DocUpdateContext var4) throws IOException;
}

