/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.util;

import java.util.ArrayList;
import java.util.List;

public final class DSelectColumnsParser {
    private final int end;
    private final String selectClause;
    private int pos;

    public static List<String> parse(String sqlSelect) {
        return new DSelectColumnsParser(sqlSelect).parse();
    }

    private DSelectColumnsParser(String selectClause) {
        this.selectClause = selectClause;
        this.end = selectClause.length();
    }

    private List<String> parse() {
        ArrayList<String> columns = new ArrayList<String>();
        while (this.pos <= this.end) {
            columns.add(this.nextColumnInfo());
        }
        return columns;
    }

    private String nextColumnInfo() {
        int start = this.pos;
        this.nextComma();
        return this.selectClause.substring(start, this.pos++).trim();
    }

    private void nextComma() {
        boolean inQuote = false;
        int inBrackets = 0;
        while (this.pos < this.end) {
            char c = this.selectClause.charAt(this.pos);
            if (c == '\'') {
                inQuote = !inQuote;
            } else if (c == '(') {
                ++inBrackets;
            } else if (c == ')') {
                --inBrackets;
            } else if (!inQuote && inBrackets == 0 && c == ',') {
                return;
            }
            ++this.pos;
        }
    }
}

