/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarTypeBaseDate;
import java.sql.Date;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.YearMonth;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;

public class ScalarTypeYearMonthDate
extends ScalarTypeBaseDate<YearMonth> {
    public ScalarTypeYearMonthDate(JsonConfig.Date mode) {
        super(mode, YearMonth.class, false, 91);
    }

    @Override
    protected String toIsoFormat(YearMonth value) {
        return value.atDay(1).toString();
    }

    protected LocalDate toLocalDate(YearMonth yearMonth) {
        return yearMonth.atDay(1);
    }

    protected YearMonth fromLocalDate(LocalDate localDate) {
        return YearMonth.of(localDate.getYear(), localDate.getMonth());
    }

    @Override
    public YearMonth convertFromMillis(long systemTimeMillis) {
        return this.fromLocalDate(new Timestamp(systemTimeMillis).toLocalDateTime().toLocalDate());
    }

    @Override
    public long convertToMillis(YearMonth value) {
        ZonedDateTime zonedDateTime = value.atDay(1).atStartOfDay(ZoneOffset.UTC);
        return zonedDateTime.toInstant().toEpochMilli();
    }

    @Override
    public YearMonth convertFromDate(Date ts) {
        return this.fromLocalDate(ts.toLocalDate());
    }

    @Override
    public Date convertToDate(YearMonth t) {
        return Date.valueOf(this.toLocalDate(t));
    }

    @Override
    public Object toJdbcType(Object value) {
        if (value instanceof Date) {
            return value;
        }
        if (value instanceof YearMonth) {
            return Date.valueOf(this.toLocalDate((YearMonth)value));
        }
        if (value instanceof LocalDate) {
            return Date.valueOf((LocalDate)value);
        }
        return BasicTypeConverter.toDate(value);
    }

    @Override
    public YearMonth toBeanType(Object value) {
        if (value instanceof YearMonth) {
            return (YearMonth)value;
        }
        if (value instanceof LocalDate) {
            return this.fromLocalDate((LocalDate)value);
        }
        if (value == null) {
            return null;
        }
        return this.fromLocalDate(BasicTypeConverter.toDate(value).toLocalDate());
    }
}

