/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.ScalarHelp;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeLogicalType;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.UUID;

public abstract class ScalarTypeUUIDBase
extends ScalarTypeBase<UUID>
implements ScalarTypeLogicalType {
    public ScalarTypeUUIDBase(boolean jdbcNative, int jdbcType) {
        super(UUID.class, jdbcNative, jdbcType);
    }

    @Override
    public int getLogicalType() {
        return 5010;
    }

    @Override
    public boolean isMutable() {
        return false;
    }

    @Override
    public boolean isDirty(Object value) {
        return true;
    }

    @Override
    public String formatValue(UUID value) {
        return value.toString();
    }

    @Override
    public UUID parse(String value) {
        return UUID.fromString(value);
    }

    @Override
    public UUID convertFromMillis(long dateTime) {
        throw new RuntimeException("Should never be called");
    }

    @Override
    public boolean isDateTimeCapable() {
        return false;
    }

    @Override
    public UUID toBeanType(Object value) {
        return BasicTypeConverter.toUUID(value, false);
    }

    @Override
    public Object toJdbcType(Object value) {
        return BasicTypeConverter.convert(value, this.jdbcType);
    }

    @Override
    public UUID readData(DataInput dataInput) throws IOException {
        if (!dataInput.readBoolean()) {
            return null;
        }
        return this.parse(dataInput.readUTF());
    }

    @Override
    public void writeData(DataOutput dataOutput, UUID value) throws IOException {
        if (value == null) {
            dataOutput.writeBoolean(false);
        } else {
            ScalarHelp.writeUTF(dataOutput, this.format(value));
        }
    }

    @Override
    public void jsonWrite(JsonGenerator writer, UUID value) throws IOException {
        writer.writeString(this.formatValue(value));
    }

    @Override
    public UUID jsonRead(JsonParser parser) throws IOException {
        return this.parse(parser.getValueAsString());
    }

    @Override
    public DocPropertyType getDocType() {
        return DocPropertyType.UUID;
    }
}

