/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.PostgresHelper;
import io.ebeaninternal.server.type.ScalarTypeJsonNode;
import java.sql.SQLException;

public abstract class ScalarTypeJsonNodePostgres
extends ScalarTypeJsonNode {
    final ObjectMapper objectMapper;
    final String postgresType;

    ScalarTypeJsonNodePostgres(ObjectMapper objectMapper, int jdbcType, String postgresType) {
        super(objectMapper, jdbcType);
        this.objectMapper = objectMapper;
        this.postgresType = postgresType;
    }

    @Override
    public void bind(DataBind bind, JsonNode value) throws SQLException {
        String rawJson = value == null ? null : this.formatValue(value);
        bind.setObject(PostgresHelper.asObject(this.postgresType, rawJson));
    }

    public static class JSONB
    extends ScalarTypeJsonNodePostgres {
        public JSONB(ObjectMapper objectMapper) {
            super(objectMapper, 5002, "jsonb");
        }
    }

    public static class JSON
    extends ScalarTypeJsonNodePostgres {
        public JSON(ObjectMapper objectMapper) {
            super(objectMapper, 5001, "json");
        }
    }
}

