/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.text.TextException;
import io.ebeaninternal.server.core.BasicTypeConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.ScalarTypeBase;
import io.ebeaninternal.server.type.ScalarTypeBool;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.SQLException;

public class ScalarTypeBoolean {

    public static abstract class BooleanBase
    extends ScalarTypeBase<Boolean>
    implements ScalarTypeBool {
        BooleanBase(boolean jdbcNative, int jdbcType) {
            super(Boolean.class, jdbcNative, jdbcType);
        }

        @Override
        public int getLogicalType() {
            return 16;
        }

        @Override
        public abstract String getDbFalseLiteral();

        @Override
        public abstract String getDbTrueLiteral();

        @Override
        public String formatValue(Boolean t) {
            return t.toString();
        }

        @Override
        public Boolean parse(String value) {
            return Boolean.valueOf(value);
        }

        @Override
        public Boolean convertFromMillis(long systemTimeMillis) {
            throw new TextException("Not Supported");
        }

        @Override
        public boolean isDateTimeCapable() {
            return false;
        }

        @Override
        public Boolean readData(DataInput dataInput) throws IOException {
            if (!dataInput.readBoolean()) {
                return null;
            }
            return dataInput.readBoolean();
        }

        @Override
        public void writeData(DataOutput dataOutput, Boolean val) throws IOException {
            if (val == null) {
                dataOutput.writeBoolean(false);
            } else {
                dataOutput.writeBoolean(true);
                dataOutput.writeBoolean(val);
            }
        }

        @Override
        public Boolean jsonRead(JsonParser parser) {
            return JsonToken.VALUE_TRUE == parser.getCurrentToken() ? Boolean.TRUE : Boolean.FALSE;
        }

        @Override
        public void jsonWrite(JsonGenerator writer, Boolean value) throws IOException {
            writer.writeBoolean(value.booleanValue());
        }

        @Override
        public DocPropertyType getDocType() {
            return DocPropertyType.BOOLEAN;
        }
    }

    static class StringBoolean
    extends BooleanBase {
        private final String trueValue;
        private final String falseValue;

        StringBoolean(String trueValue, String falseValue) {
            super(false, 12);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public String getDbFalseLiteral() {
            return "'" + this.falseValue + "'";
        }

        @Override
        public String getDbTrueLiteral() {
            return "'" + this.trueValue + "'";
        }

        @Override
        public int getLength() {
            return Math.max(this.trueValue.length(), this.falseValue.length());
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(12);
            } else {
                b.setString(this.toString(value));
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            String string = dataReader.getString();
            if (string == null) {
                return null;
            }
            if (string.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Object toJdbcType(Object value) {
            return this.toString(value);
        }

        public String toString(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            return b != false ? this.trueValue : this.falseValue;
        }

        @Override
        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class IntBoolean
    extends BooleanBase {
        private final Integer trueValue;
        private final Integer falseValue;

        IntBoolean(Integer trueValue, Integer falseValue) {
            super(false, 4);
            this.trueValue = trueValue;
            this.falseValue = falseValue;
        }

        @Override
        public String getDbFalseLiteral() {
            return this.falseValue.toString();
        }

        @Override
        public String getDbTrueLiteral() {
            return this.trueValue.toString();
        }

        @Override
        public int getLength() {
            return 1;
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(4);
            } else {
                b.setInt(this.toInteger(value));
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            Integer i = dataReader.getInt();
            if (i == null) {
                return null;
            }
            if (i.equals(this.trueValue)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }

        @Override
        public Object toJdbcType(Object value) {
            return this.toInteger(value);
        }

        Integer toInteger(Object value) {
            if (value == null) {
                return null;
            }
            Boolean b = (Boolean)value;
            return b != false ? this.trueValue : this.falseValue;
        }

        @Override
        public Boolean toBeanType(Object value) {
            if (value == null) {
                return null;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (this.trueValue.equals(value)) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    static class BitBoolean
    extends BooleanBase {
        BitBoolean() {
            super(true, -7);
        }

        @Override
        public String getDbFalseLiteral() {
            return "0";
        }

        @Override
        public String getDbTrueLiteral() {
            return "1";
        }

        @Override
        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(-7);
            } else {
                b.setBoolean(value);
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            return dataReader.getBoolean();
        }
    }

    public static class Native
    extends BooleanBase {
        public Native() {
            super(true, 16);
        }

        @Override
        public String getDbFalseLiteral() {
            return "false";
        }

        @Override
        public String getDbTrueLiteral() {
            return "true";
        }

        @Override
        public Boolean toBeanType(Object value) {
            return BasicTypeConverter.toBoolean(value);
        }

        @Override
        public Object toJdbcType(Object value) {
            return BasicTypeConverter.convert(value, this.jdbcType);
        }

        @Override
        public void bind(DataBind b, Boolean value) throws SQLException {
            if (value == null) {
                b.setNull(16);
            } else {
                b.setBoolean(value);
            }
        }

        @Override
        public Boolean read(DataReader dataReader) throws SQLException {
            return dataReader.getBoolean();
        }
    }
}

