/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import io.ebean.text.TextException;
import io.ebean.text.json.EJson;
import io.ebeaninternal.json.ModifyAwareSet;
import io.ebeaninternal.server.type.ArrayElementConverter;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.PlatformArrayTypeFactory;
import io.ebeaninternal.server.type.ScalarType;
import io.ebeaninternal.server.type.ScalarTypeArray;
import io.ebeaninternal.server.type.ScalarTypeArrayBase;
import io.ebeanservice.docstore.api.mapping.DocPropertyType;
import java.io.IOException;
import java.lang.reflect.Type;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;

public class ScalarTypeArraySet
extends ScalarTypeArrayBase<Set>
implements ScalarTypeArray {
    private final String arrayType;
    private final ArrayElementConverter converter;

    static PlatformArrayTypeFactory factory() {
        return new Factory();
    }

    public ScalarTypeArraySet(boolean nullable, String arrayType, DocPropertyType docPropertyType, ArrayElementConverter converter) {
        super(Set.class, 2003, docPropertyType, nullable);
        this.arrayType = arrayType;
        this.converter = converter;
    }

    @Override
    public DocPropertyType getDocType() {
        return this.docPropertyType;
    }

    @Override
    public String getDbColumnDefn() {
        return this.arrayType + "[]";
    }

    @Override
    protected Set fromArray(Object[] array1) {
        LinkedHashSet set = new LinkedHashSet();
        for (Object element : array1) {
            set.add(this.converter.toElement(element));
        }
        return new ModifyAwareSet(set);
    }

    protected Object[] toArray(Set value) {
        return this.converter.toDbArray(value.toArray());
    }

    @Override
    public void bind(DataBind bind, Set value) throws SQLException {
        if (value == null) {
            this.bindNull(bind);
        } else {
            bind.setArray(this.arrayType, this.toArray(value));
        }
    }

    @Override
    protected void bindNull(DataBind bind) throws SQLException {
        if (this.nullable) {
            bind.setNull(2003);
        } else {
            bind.setArray(this.arrayType, this.toArray(Collections.EMPTY_SET));
        }
    }

    @Override
    public String formatValue(Set value) {
        try {
            return EJson.write((Object)value);
        }
        catch (IOException e) {
            throw new PersistenceException("Failed to format List into JSON content", (Throwable)e);
        }
    }

    @Override
    public Set parse(String value) {
        try {
            return EJson.parseSet((String)value, (boolean)false);
        }
        catch (IOException e) {
            throw new TextException("Failed to parse JSON [{}] as Set", value, (Exception)e);
        }
    }

    @Override
    public Set jsonRead(JsonParser parser) throws IOException {
        return EJson.parseSet((JsonParser)parser, (JsonToken)parser.getCurrentToken());
    }

    @Override
    public void jsonWrite(JsonGenerator writer, Set value) throws IOException {
        EJson.write((Object)value, (JsonGenerator)writer);
    }

    static class Factory
    implements PlatformArrayTypeFactory {
        private final ReentrantLock lock = new ReentrantLock(false);
        private final Map<String, ScalarTypeArraySet> cache = new HashMap<String, ScalarTypeArraySet>();

        Factory() {
        }

        @Override
        public ScalarType<?> typeFor(Type valueType, boolean nullable) {
            this.lock.lock();
            try {
                String key = valueType + ":" + nullable;
                if (valueType.equals(UUID.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySet(nullable, "uuid", DocPropertyType.UUID, ArrayElementConverter.UUID));
                    return scalarType;
                }
                if (valueType.equals(Long.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySet(nullable, "bigint", DocPropertyType.LONG, ArrayElementConverter.LONG));
                    return scalarType;
                }
                if (valueType.equals(Integer.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySet(nullable, "integer", DocPropertyType.INTEGER, ArrayElementConverter.INTEGER));
                    return scalarType;
                }
                if (valueType.equals(Double.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySet(nullable, "float", DocPropertyType.DOUBLE, ArrayElementConverter.DOUBLE));
                    return scalarType;
                }
                if (valueType.equals(String.class)) {
                    ScalarType scalarType = this.cache.computeIfAbsent(key, s -> new ScalarTypeArraySet(nullable, "varchar", DocPropertyType.TEXT, ArrayElementConverter.STRING));
                    return scalarType;
                }
                throw new IllegalArgumentException("Type [" + valueType + "] not supported for @DbArray mapping");
            }
            finally {
                this.lock.unlock();
            }
        }

        @Override
        public ScalarType<?> typeForEnum(ScalarType<?> scalarType, boolean nullable) {
            return new ScalarTypeArraySet(nullable, ScalarTypeArrayBase.arrayTypeFor(scalarType), scalarType.getDocType(), new ArrayElementConverter.EnumConverter(scalarType));
        }
    }
}

