/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.transaction;

import io.ebeaninternal.api.BinaryReadContext;
import io.ebeaninternal.api.BinaryWritable;
import io.ebeaninternal.api.BinaryWriteContext;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.RemoteCacheEvent;
import io.ebeaninternal.server.transaction.BeanPersistIds;
import io.ebeaninternal.server.transaction.DeleteByIdMap;
import io.ebeaninternal.server.transaction.RemoteTableMod;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class RemoteTransactionEvent
implements Runnable,
BinaryWritable {
    private final List<BeanPersistIds> beanPersistList = new ArrayList<BeanPersistIds>();
    private List<TransactionEventTable.TableIUD> tableList;
    private DeleteByIdMap deleteByIdMap;
    private RemoteCacheEvent remoteCacheEvent;
    private RemoteTableMod remoteTableMod;
    private String serverName;
    private transient SpiEbeanServer server;

    public RemoteTransactionEvent(String serverName) {
        this.serverName = serverName;
    }

    public RemoteTransactionEvent(SpiEbeanServer server) {
        this.server = server;
    }

    @Override
    public void run() {
        this.server.remoteTransactionEvent(this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(100);
        sb.append("TransEvent[");
        if (this.remoteTableMod != null) {
            sb.append(this.remoteTableMod);
        }
        if (!this.beanPersistList.isEmpty()) {
            sb.append(this.beanPersistList);
        }
        if (this.tableList != null) {
            sb.append(this.tableList);
        }
        if (this.deleteByIdMap != null) {
            sb.append(this.deleteByIdMap);
        }
        sb.append("]");
        return sb.toString();
    }

    public void readBinary(BinaryReadContext dataInput) throws IOException {
        boolean more = dataInput.readBoolean();
        while (more) {
            int msgType = dataInput.readInt();
            this.readBinaryMessage(msgType, dataInput);
            more = dataInput.readBoolean();
        }
    }

    private void readBinaryMessage(int msgType, BinaryReadContext dataInput) throws IOException {
        switch (msgType) {
            case 1: {
                this.addBeanPersistIds(BeanPersistIds.readBinaryMessage(this.server, dataInput));
                break;
            }
            case 2: {
                this.addTableIUD(TransactionEventTable.TableIUD.readBinaryMessage(dataInput));
                break;
            }
            case 3: {
                this.addRemoteCacheEvent(RemoteCacheEvent.readBinaryMessage(dataInput));
                break;
            }
            case 4: {
                this.addRemoteTableMod(RemoteTableMod.readBinaryMessage(dataInput));
                break;
            }
            default: {
                throw new RuntimeException("Invalid Transaction msgType " + msgType);
            }
        }
    }

    public byte[] writeBinaryAsBytes(int bufferSize) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(bufferSize);
        DataOutputStream out = new DataOutputStream(buffer);
        BinaryWriteContext context = new BinaryWriteContext(out);
        this.writeBinary(context);
        out.close();
        return buffer.toByteArray();
    }

    @Override
    public void writeBinary(BinaryWriteContext out) throws IOException {
        DataOutputStream os = out.os();
        os.writeUTF(this.serverName);
        if (this.remoteTableMod != null) {
            this.remoteTableMod.writeBinary(out);
        }
        if (this.tableList != null) {
            for (TransactionEventTable.TableIUD aTableList : this.tableList) {
                aTableList.writeBinary(out);
            }
        }
        if (this.deleteByIdMap != null) {
            for (BeanPersistIds deleteIds : this.deleteByIdMap.values()) {
                deleteIds.writeBinary(out);
            }
        }
        for (BeanPersistIds aBeanPersistList : this.beanPersistList) {
            aBeanPersistList.writeBinary(out);
        }
        if (this.remoteCacheEvent != null) {
            this.remoteCacheEvent.writeBinary(out);
        }
        out.end();
        os.flush();
    }

    public boolean isEmpty() {
        return !(!this.beanPersistList.isEmpty() || this.tableList != null && !this.tableList.isEmpty() || this.deleteByIdMap != null && !this.deleteByIdMap.isEmpty());
    }

    public void addBeanPersistIds(BeanPersistIds beanPersist) {
        this.beanPersistList.add(beanPersist);
    }

    public RemoteTransactionEvent cacheClearAll() {
        this.remoteCacheEvent = new RemoteCacheEvent(true);
        return this;
    }

    public RemoteTransactionEvent cacheClear(Class<?> beanType) {
        this.remoteCacheEvent = new RemoteCacheEvent(beanType);
        return this;
    }

    public void addRemoteCacheEvent(RemoteCacheEvent remoteCacheEvent) {
        this.remoteCacheEvent = remoteCacheEvent;
    }

    public void addTableIUD(TransactionEventTable.TableIUD tableIud) {
        if (this.tableList == null) {
            this.tableList = new ArrayList<TransactionEventTable.TableIUD>(4);
        }
        this.tableList.add(tableIud);
    }

    public void addRemoteTableMod(RemoteTableMod remoteTableMod) {
        this.remoteTableMod = remoteTableMod;
    }

    public String getServerName() {
        return this.serverName;
    }

    public SpiEbeanServer getServer() {
        return this.server;
    }

    public void setServer(SpiEbeanServer server) {
        this.server = server;
    }

    void setDeleteByIdMap(DeleteByIdMap deleteByIdMap) {
        this.deleteByIdMap = deleteByIdMap;
    }

    public List<TransactionEventTable.TableIUD> getTableIUDList() {
        return this.tableList;
    }

    public List<BeanPersistIds> getBeanPersistList() {
        return this.beanPersistList;
    }

    public RemoteCacheEvent getRemoteCacheEvent() {
        return this.remoteCacheEvent;
    }

    public RemoteTableMod getRemoteTableMod() {
        return this.remoteTableMod;
    }
}

