/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.text.csv;

import io.ebean.Database;
import io.ebean.bean.EntityBean;
import io.ebean.plugin.ExpressionPath;
import io.ebean.text.StringParser;
import io.ebean.text.TextException;
import io.ebean.text.TimeStringParser;
import io.ebean.text.csv.CsvCallback;
import io.ebean.text.csv.CsvReader;
import io.ebean.text.csv.DefaultCsvCallback;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.text.csv.CsvUtilReader;
import java.io.Reader;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Locale;

public class TCsvReader<T>
implements CsvReader<T> {
    private static final TimeStringParser TIME_PARSER = new TimeStringParser();
    private final Database server;
    private final BeanDescriptor<T> descriptor;
    private final List<CsvColumn> columnList = new ArrayList<CsvColumn>();
    private final CsvColumn ignoreColumn = new CsvColumn();
    private boolean hasHeader;
    private int logInfoFrequency = 1000;
    private String defaultTimeFormat = "HH:mm:ss";
    private String defaultDateFormat = "yyyy-MM-dd";
    private String defaultTimestampFormat = "yyyy-MM-dd hh:mm:ss.fffffffff";
    private Locale defaultLocale = Locale.getDefault();
    protected int persistBatchSize = 30;
    private boolean addPropertiesFromHeader;

    public TCsvReader(Database server, BeanDescriptor<T> descriptor) {
        this.server = server;
        this.descriptor = descriptor;
    }

    public void setDefaultLocale(Locale defaultLocale) {
        this.defaultLocale = defaultLocale;
    }

    public void setDefaultTimeFormat(String defaultTimeFormat) {
        this.defaultTimeFormat = defaultTimeFormat;
    }

    public void setDefaultDateFormat(String defaultDateFormat) {
        this.defaultDateFormat = defaultDateFormat;
    }

    public void setDefaultTimestampFormat(String defaultTimestampFormat) {
        this.defaultTimestampFormat = defaultTimestampFormat;
    }

    public void setPersistBatchSize(int persistBatchSize) {
        this.persistBatchSize = persistBatchSize;
    }

    public void setIgnoreHeader() {
        this.setHasHeader(true, false);
    }

    public void setAddPropertiesFromHeader() {
        this.setHasHeader(true, true);
    }

    public void setHasHeader(boolean hasHeader, boolean addPropertiesFromHeader) {
        this.hasHeader = hasHeader;
        this.addPropertiesFromHeader = addPropertiesFromHeader;
    }

    public void setLogInfoFrequency(int logInfoFrequency) {
        this.logInfoFrequency = logInfoFrequency;
    }

    public void addIgnore() {
        this.columnList.add(this.ignoreColumn);
    }

    public void addProperty(String propertyName) {
        this.addProperty(propertyName, null);
    }

    public void addDateTime(String propertyName, String dateTimeFormat) {
        this.addDateTime(propertyName, dateTimeFormat, Locale.getDefault());
    }

    public void addDateTime(String propertyName, String dateTimeFormat, Locale locale) {
        ExpressionPath elProp = this.descriptor.getExpressionPath(propertyName);
        if (!elProp.isDateTimeCapable()) {
            throw new TextException("Property " + propertyName + " is not DateTime capable");
        }
        if (dateTimeFormat == null) {
            dateTimeFormat = this.getDefaultDateTimeFormat(elProp.getJdbcType());
        }
        if (locale == null) {
            locale = this.defaultLocale;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateTimeFormat, locale);
        DateTimeParser parser = new DateTimeParser(sdf, dateTimeFormat, elProp);
        CsvColumn column = new CsvColumn(elProp, parser);
        this.columnList.add(column);
    }

    private String getDefaultDateTimeFormat(int jdbcType) {
        switch (jdbcType) {
            case 92: {
                return this.defaultTimeFormat;
            }
            case 91: {
                return this.defaultDateFormat;
            }
            case 93: {
                return this.defaultTimestampFormat;
            }
        }
        throw new RuntimeException("Expected java.sql.Types TIME,DATE or TIMESTAMP but got [" + jdbcType + "]");
    }

    public void addProperty(String propertyName, StringParser parser) {
        ExpressionPath elProp = this.descriptor.getExpressionPath(propertyName);
        if (parser == null) {
            parser = elProp.getStringParser();
        }
        CsvColumn column = new CsvColumn(elProp, parser);
        this.columnList.add(column);
    }

    public void process(Reader reader) throws Exception {
        DefaultCsvCallback callback = new DefaultCsvCallback(this.persistBatchSize, this.logInfoFrequency);
        this.process(reader, (CsvCallback<T>)callback);
    }

    public void process(Reader reader, CsvCallback<T> callback) throws Exception {
        Object[] line;
        if (reader == null) {
            throw new NullPointerException("reader is null?");
        }
        if (callback == null) {
            throw new NullPointerException("callback is null?");
        }
        CsvUtilReader utilReader = new CsvUtilReader(reader);
        callback.begin(this.server);
        int row = 0;
        if (this.hasHeader) {
            line = utilReader.readNext();
            if (this.addPropertiesFromHeader) {
                this.addPropertiesFromHeader((String[])line);
            }
            callback.readHeader((String[])line);
        }
        try {
            while (true) {
                ++row;
                line = utilReader.readNext();
                if (line == null) break;
                if (!callback.processLine(row, (String[])line)) continue;
                if (line.length != this.columnList.size()) {
                    String msg = "Error at line " + row + ". Expected [" + this.columnList.size() + "] columns but instead we have [" + line.length + "].  Line[" + Arrays.toString(line) + "]";
                    throw new TextException(msg);
                }
                T bean = this.buildBeanFromLineContent(row, (String[])line);
                callback.processBean(row, (String[])line, bean);
            }
            callback.end(--row);
        }
        catch (Exception e) {
            callback.endWithError(row, e);
            throw e;
        }
    }

    private void addPropertiesFromHeader(String[] line) {
        for (String aLine : line) {
            ElPropertyValue elProp = this.descriptor.getElGetValue(aLine);
            if (elProp == null) {
                throw new TextException("Property [" + aLine + "] not found");
            }
            if (92 == elProp.getJdbcType()) {
                this.addProperty(aLine, (StringParser)TIME_PARSER);
                continue;
            }
            if (this.isDateTimeType(elProp.getJdbcType())) {
                this.addDateTime(aLine, null, null);
                continue;
            }
            if (elProp.isAssocProperty()) {
                BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)elProp.getBeanProperty();
                String idProp = assocOne.getBeanDescriptor().getIdBinder().getIdProperty();
                this.addProperty(aLine + "." + idProp);
                continue;
            }
            this.addProperty(aLine);
        }
    }

    private boolean isDateTimeType(int t) {
        return t == 93 || t == 91 || t == 92;
    }

    protected T buildBeanFromLineContent(int row, String[] line) {
        try {
            EntityBean entityBean;
            EntityBean bean = entityBean = this.descriptor.createEntityBean();
            for (int columnPos = 0; columnPos < line.length; ++columnPos) {
                this.convertAndSetColumn(columnPos, line[columnPos], entityBean);
            }
            return (T)bean;
        }
        catch (RuntimeException e) {
            String msg = "Error at line: " + row + " line[" + Arrays.toString(line) + "]";
            throw new RuntimeException(msg, e);
        }
    }

    protected void convertAndSetColumn(int columnPos, String strValue, EntityBean bean) {
        if ((strValue = strValue.trim()).isEmpty()) {
            return;
        }
        CsvColumn c = this.columnList.get(columnPos);
        c.convertAndSet(strValue, bean);
    }

    private static class DateTimeParser
    implements StringParser {
        private final DateFormat dateFormat;
        private final ExpressionPath path;
        private final String format;

        DateTimeParser(DateFormat dateFormat, String format, ExpressionPath path) {
            this.dateFormat = dateFormat;
            this.path = path;
            this.format = format;
        }

        public Object parse(String value) {
            try {
                Date dt = this.dateFormat.parse(value);
                return this.path.parseDateTime(dt.getTime());
            }
            catch (ParseException e) {
                throw new TextException("Error parsing [{}] using format[" + this.format + "]", value, (Exception)e);
            }
        }
    }

    public static class CsvColumn {
        private final ExpressionPath path;
        private final StringParser parser;

        private CsvColumn() {
            this.path = null;
            this.parser = null;
        }

        public CsvColumn(ExpressionPath path, StringParser parser) {
            this.path = path;
            this.parser = parser;
        }

        public void convertAndSet(String strValue, EntityBean bean) {
            if (this.parser != null && this.path != null) {
                Object value = this.parser.parse(strValue);
                this.path.pathSet((Object)bean, value);
            }
        }
    }
}

