/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.querydefn;

import io.ebean.Expression;
import io.ebean.ExpressionFactory;
import io.ebean.FetchConfig;
import io.ebean.OrderBy;
import io.ebean.Query;
import io.ebean.util.SplitName;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionFactory;
import io.ebeaninternal.api.SpiExpressionList;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.FilterExprPath;
import io.ebeaninternal.server.expression.FilterExpressionList;
import io.ebeaninternal.server.querydefn.OrmQueryPropertiesParser;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public class OrmQueryProperties
implements Serializable {
    private static final long serialVersionUID = -8785582703966455658L;
    static final FetchConfig DEFAULT_FETCH = new FetchConfig();
    private final String parentPath;
    private final String path;
    private final String rawProperties;
    private final String trimmedProperties;
    private final LinkedHashSet<String> included;
    private final FetchConfig fetchConfig;
    private boolean markForQueryJoin;
    private boolean cache;
    private boolean readOnly;
    private Set<String> includedBeanJoin;
    private Set<String> secondaryQueryJoins;
    private List<OrmQueryProperties> secondaryChildren;
    private OrderBy orderBy;
    private SpiExpressionList filterMany;

    public OrmQueryProperties() {
        this(null);
    }

    public OrmQueryProperties(String path) {
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.rawProperties = null;
        this.trimmedProperties = null;
        this.included = null;
        this.fetchConfig = DEFAULT_FETCH;
    }

    public OrmQueryProperties(String path, String rawProperties) {
        this(path, rawProperties, null);
    }

    public OrmQueryProperties(String path, String rawProperties, FetchConfig fetchConfig) {
        OrmQueryPropertiesParser.Response response = OrmQueryPropertiesParser.parse(rawProperties);
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.rawProperties = rawProperties;
        this.trimmedProperties = response.properties;
        this.included = response.included;
        this.cache = response.cache;
        this.readOnly = response.readOnly;
        if (fetchConfig != null) {
            this.fetchConfig = fetchConfig;
            if (fetchConfig.isCache()) {
                this.cache = true;
            }
        } else {
            this.fetchConfig = response.fetchConfig;
        }
    }

    public OrmQueryProperties(String path, LinkedHashSet<String> parsedProperties) {
        if (parsedProperties == null) {
            throw new IllegalArgumentException("parsedProperties is null");
        }
        this.path = path;
        this.parentPath = SplitName.parent((String)path);
        this.included = parsedProperties;
        this.trimmedProperties = this.rawProperties = this.join(parsedProperties);
        this.cache = false;
        this.readOnly = false;
        this.fetchConfig = DEFAULT_FETCH;
    }

    private String join(LinkedHashSet<String> parsedProperties) {
        StringBuilder sb = new StringBuilder(50);
        boolean first = true;
        for (String property : parsedProperties) {
            if (first) {
                first = false;
            } else {
                sb.append(",");
            }
            sb.append(property);
        }
        return sb.toString();
    }

    private OrmQueryProperties(OrmQueryProperties source, FetchConfig sourceFetchConfig) {
        this.fetchConfig = sourceFetchConfig;
        this.parentPath = source.parentPath;
        this.path = source.path;
        this.rawProperties = source.rawProperties;
        this.trimmedProperties = source.trimmedProperties;
        this.cache = source.cache;
        this.readOnly = source.readOnly;
        this.filterMany = source.filterMany;
        this.markForQueryJoin = source.markForQueryJoin;
        this.included = source.included == null ? null : new LinkedHashSet<String>(source.included);
    }

    public OrmQueryProperties copy() {
        return new OrmQueryProperties(this, this.fetchConfig);
    }

    public OrmQueryProperties copy(FetchConfig fetchConfig) {
        return new OrmQueryProperties(this, fetchConfig);
    }

    void addSecJoinOrderProperty(OrderBy.Property orderProp) {
        if (this.orderBy == null) {
            this.orderBy = new OrderBy();
        }
        this.orderBy.add(orderProp);
    }

    public FetchConfig getFetchConfig() {
        return this.fetchConfig;
    }

    public <T> SpiExpressionList<T> filterMany(Query<T> rootQuery) {
        if (this.filterMany == null) {
            FilterExprPath exprPath = new FilterExprPath(this.path);
            SpiExpressionFactory queryEf = (SpiExpressionFactory)rootQuery.getExpressionFactory();
            ExpressionFactory filterEf = queryEf.createExpressionFactory();
            this.filterMany = new FilterExpressionList<T>(exprPath, filterEf, rootQuery);
            this.markForQueryJoin = true;
        }
        return this.filterMany;
    }

    private SpiExpressionList<?> getFilterManyTrimPath(int trimPath) {
        if (this.filterMany == null) {
            return null;
        }
        return this.filterMany.trimPath(trimPath);
    }

    public SpiExpressionList<?> getFilterMany() {
        return this.filterMany;
    }

    public void setFilterMany(SpiExpressionList<?> filterMany) {
        this.filterMany = filterMany;
        this.markForQueryJoin = true;
    }

    public void configureBeanQuery(SpiQuery<?> query) {
        if (this.trimmedProperties != null && !this.trimmedProperties.isEmpty()) {
            query.select(this.trimmedProperties);
        }
        if (this.filterMany != null) {
            this.filterMany.applyRowLimits(query);
            SpiExpressionList<?> trimPath = this.filterMany.trimPath(this.path.length() + 1);
            for (SpiExpression spiExpression : trimPath.getUnderlyingList()) {
                query.where().add((Expression)spiExpression);
            }
        }
        if (this.secondaryChildren != null) {
            int trimPath = this.path.length() + 1;
            for (OrmQueryProperties p : this.secondaryChildren) {
                String path = p.getPath();
                path = path.substring(trimPath);
                query.fetch(path, p.getProperties(), p.getFetchConfig());
                query.setFilterMany(path, p.getFilterManyTrimPath(trimPath));
            }
        }
        if (this.orderBy != null) {
            query.setOrder(this.orderBy.copyWithTrim(this.path));
        }
    }

    public boolean hasSelectClause() {
        if ("*".equals(this.trimmedProperties)) {
            return true;
        }
        return this.included != null || this.filterMany != null;
    }

    public boolean isEmpty() {
        return this.rawProperties == null || this.rawProperties.isEmpty();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(40);
        this.append("", sb);
        return sb.toString();
    }

    public String append(String prefix, StringBuilder sb) {
        sb.append(prefix);
        if (this.path != null) {
            sb.append(this.path).append(" ");
        }
        if (!this.isEmpty()) {
            sb.append("(").append(this.rawProperties).append(")");
        }
        return sb.toString();
    }

    boolean isChild(OrmQueryProperties possibleChild) {
        return possibleChild.getPath().startsWith(this.path + ".");
    }

    public void add(OrmQueryProperties child) {
        if (this.secondaryChildren == null) {
            this.secondaryChildren = new ArrayList<OrmQueryProperties>();
        }
        this.secondaryChildren.add(child);
    }

    public String getProperties() {
        return this.rawProperties;
    }

    public boolean allProperties() {
        return this.included == null;
    }

    public boolean isIncludedBeanJoin(String propertyName) {
        return this.includedBeanJoin != null && this.includedBeanJoin.contains(propertyName);
    }

    void includeBeanJoin(String propertyName) {
        if (this.includedBeanJoin == null) {
            this.includedBeanJoin = new HashSet<String>();
        }
        this.includedBeanJoin.add(propertyName);
    }

    public Set<String> getSelectInclude() {
        return this.included;
    }

    public Set<String> getSelectQueryJoin() {
        return this.secondaryQueryJoins;
    }

    void addSecondaryQueryJoin(String property) {
        if (this.secondaryQueryJoins == null) {
            this.secondaryQueryJoins = new HashSet<String>(4);
        }
        this.secondaryQueryJoins.add(property);
    }

    public Set<String> getIncluded() {
        return this.included;
    }

    boolean isIncluded(String propName) {
        if (this.includedBeanJoin != null && this.includedBeanJoin.contains(propName)) {
            return false;
        }
        return this.included == null || this.included.contains(propName);
    }

    void markForQueryJoin() {
        this.markForQueryJoin = true;
    }

    public boolean isQueryFetch() {
        return this.markForQueryJoin || this.getQueryFetchBatch() > -1;
    }

    boolean isFetchJoin() {
        return !this.isQueryFetch() && !this.isLazyFetch();
    }

    boolean isLazyFetch() {
        return this.getLazyFetchBatch() > -1;
    }

    public int getQueryFetchBatch() {
        return this.fetchConfig.getQueryBatchSize();
    }

    public boolean isQueryFetchAll() {
        return this.fetchConfig.isQueryAll();
    }

    public int getLazyFetchBatch() {
        return this.fetchConfig.getLazyBatchSize();
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isCache() {
        return this.cache;
    }

    String getParentPath() {
        return this.parentPath;
    }

    public String getPath() {
        return this.path;
    }

    boolean isSameByAutoTune(OrmQueryProperties p2) {
        if (this.included == null) {
            return p2 == null || p2.included == null;
        }
        if (p2 == null) {
            return false;
        }
        return this.included.equals(p2.included);
    }

    public void queryPlanHash(StringBuilder builder) {
        builder.append("qpp[");
        builder.append(this.path);
        if (this.included != null) {
            builder.append(" included:").append(this.included);
        }
        if (this.secondaryQueryJoins != null) {
            builder.append(" secondary:").append(this.secondaryQueryJoins);
        }
        if (this.filterMany != null) {
            builder.append(" filterMany[");
            this.filterMany.queryPlanHash(builder);
            builder.append("]");
        }
        if (this.fetchConfig != null) {
            builder.append(" config:").append(this.fetchConfig.hashCode());
        }
        builder.append("]");
    }
}

