/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.ProfileLocation;
import io.ebean.Query;
import io.ebean.config.dbplatform.SqlLimitResponse;
import io.ebean.metric.MetricFactory;
import io.ebean.metric.TimedMetric;
import io.ebeaninternal.api.CQueryPlanKey;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiQueryBindCapture;
import io.ebeaninternal.api.SpiQueryPlan;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.timezone.DataTimeZone;
import io.ebeaninternal.server.query.CQueryPlanStats;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.query.DQueryPlanOutput;
import io.ebeaninternal.server.query.RawSqlQueryPlanKey;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.query.SqlTree;
import io.ebeaninternal.server.type.DataBind;
import io.ebeaninternal.server.type.DataBindCapture;
import io.ebeaninternal.server.type.DataReader;
import io.ebeaninternal.server.type.RsetDataReader;
import io.ebeaninternal.server.type.ScalarDataReader;
import io.ebeaninternal.server.util.Md5;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryPlan
implements SpiQueryPlan {
    private static final Logger logger = LoggerFactory.getLogger(CQueryPlan.class);
    static final String RESULT_SET_BASED_RAW_SQL = "--ResultSetBasedRawSql";
    private final SpiEbeanServer server;
    private final ProfileLocation profileLocation;
    private final String location;
    private final String label;
    private final String name;
    private final CQueryPlanKey planKey;
    private final boolean rawSql;
    private final String sql;
    private final String hash;
    private final String logWhereSql;
    private final SqlTree sqlTree;
    private final STreeProperty[] encryptedProps;
    private final CQueryPlanStats stats;
    private final Class<?> beanType;
    final DataTimeZone dataTimeZone;
    private final int asOfTableCount;
    private volatile String auditQueryHash;
    private final Set<String> dependentTables;
    private final SpiQueryBindCapture bindCapture;

    CQueryPlan(OrmQueryRequest<?> request, SqlLimitResponse sqlRes, SqlTree sqlTree, boolean rawSql, String logWhereSql) {
        this.server = request.getServer();
        this.dataTimeZone = this.server.getDataTimeZone();
        this.beanType = request.getBeanDescriptor().getBeanType();
        this.planKey = request.getQueryPlanKey();
        Query query = request.getQuery();
        this.profileLocation = query.getProfileLocation();
        this.label = query.getPlanLabel();
        this.name = this.deriveName(this.label, query.getType());
        this.location = this.location();
        this.asOfTableCount = query.getAsOfTableCount();
        this.sql = sqlRes.getSql();
        this.sqlTree = sqlTree;
        this.rawSql = rawSql;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
        this.stats = new CQueryPlanStats(this);
        this.dependentTables = sqlTree.dependentTables();
        this.bindCapture = this.initBindCapture((SpiQuery<?>)query);
        this.hash = this.md5Hash();
    }

    CQueryPlan(OrmQueryRequest<?> request, String sql, SqlTree sqlTree, String logWhereSql) {
        this.server = request.getServer();
        this.dataTimeZone = this.server.getDataTimeZone();
        this.beanType = request.getBeanDescriptor().getBeanType();
        Query query = request.getQuery();
        this.profileLocation = query.getProfileLocation();
        this.label = query.getPlanLabel();
        this.name = this.deriveName(this.label, query.getType());
        this.location = this.location();
        this.planKey = this.buildPlanKey(sql, logWhereSql);
        this.asOfTableCount = 0;
        this.sql = sql;
        this.sqlTree = sqlTree;
        this.rawSql = false;
        this.logWhereSql = logWhereSql;
        this.encryptedProps = sqlTree.getEncryptedProps();
        this.stats = new CQueryPlanStats(this);
        this.dependentTables = sqlTree.dependentTables();
        this.bindCapture = this.initBindCaptureRaw(sql, (SpiQuery<?>)query);
        this.hash = this.md5Hash();
    }

    private String deriveName(String label, SpiQuery.Type type) {
        if (label == null) {
            return "orm." + this.beanType.getSimpleName() + "." + type.label();
        }
        if (label.startsWith(this.beanType.getSimpleName())) {
            return "orm." + label;
        }
        return "orm." + this.beanType.getSimpleName() + "_" + label;
    }

    private SpiQueryBindCapture initBindCapture(SpiQuery<?> query) {
        return query.getType().isUpdate() ? SpiQueryBindCapture.NOOP : this.server.createQueryBindCapture(this);
    }

    private SpiQueryBindCapture initBindCaptureRaw(String sql, SpiQuery<?> query) {
        return sql.equals(RESULT_SET_BASED_RAW_SQL) || query.getType().isUpdate() ? SpiQueryBindCapture.NOOP : this.server.createQueryBindCapture(this);
    }

    private String location() {
        return this.profileLocation == null ? null : this.profileLocation.location();
    }

    private CQueryPlanKey buildPlanKey(String sql, String logWhereSql) {
        return new RawSqlQueryPlanKey(sql, false, logWhereSql);
    }

    public String toString() {
        return this.beanType + " hash:" + this.planKey;
    }

    @Override
    public Class<?> getBeanType() {
        return this.beanType;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getHash() {
        return this.hash;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public ProfileLocation getProfileLocation() {
        return this.profileLocation;
    }

    public String getLabel() {
        return this.label;
    }

    public Set<String> getDependentTables() {
        return this.dependentTables;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public void queryPlanInit(long thresholdMicros) {
        this.bindCapture.queryPlanInit(thresholdMicros);
    }

    @Override
    public DQueryPlanOutput createMeta(String bind, String planString) {
        return new DQueryPlanOutput(this.getBeanType(), this.name, this.hash, this.sql, this.profileLocation, bind, planString);
    }

    public DataReader createDataReader(ResultSet rset) {
        return new RsetDataReader(this.dataTimeZone, rset);
    }

    DataBind bindEncryptedProperties(PreparedStatement stmt, Connection conn) throws SQLException {
        DataBind dataBind = new DataBind(this.dataTimeZone, stmt, conn);
        if (this.encryptedProps != null) {
            for (STreeProperty encryptedProp : this.encryptedProps) {
                dataBind.setString(encryptedProp.getEncryptKeyAsString());
            }
        }
        return dataBind;
    }

    private DataBindCapture bindCapture() throws SQLException {
        DataBindCapture dataBind = DataBindCapture.of(this.dataTimeZone);
        if (this.encryptedProps != null) {
            for (STreeProperty encryptedProp : this.encryptedProps) {
                dataBind.setString(encryptedProp.getEncryptKeyAsString());
            }
        }
        return dataBind;
    }

    int getAsOfTableCount() {
        return this.asOfTableCount;
    }

    String getAuditQueryKey() {
        if (this.auditQueryHash == null) {
            this.auditQueryHash = this.calcAuditQueryKey();
        }
        return this.auditQueryHash;
    }

    private String calcAuditQueryKey() {
        return this.rawSql ? this.planKey.getPartialKey() + "_" + this.hash : this.planKey.getPartialKey();
    }

    private String md5Hash() {
        StringBuilder sb = new StringBuilder(this.sql).append("|").append(this.name).append("|").append(this.location);
        try {
            return Md5.hash(sb.toString());
        }
        catch (Exception e) {
            logger.error("Failed to MD5 hash the query", (Throwable)e);
            return "error";
        }
    }

    SqlTree getSqlTree() {
        return this.sqlTree;
    }

    public boolean isRawSql() {
        return this.rawSql;
    }

    String getLogWhereSql() {
        return this.logWhereSql;
    }

    public void resetStatistics() {
        this.stats.reset();
    }

    boolean executionTime(long timeMicros) {
        this.stats.add(timeMicros);
        return this.bindCapture != null && this.bindCapture.collectFor(timeMicros);
    }

    public CQueryPlanStats.Snapshot getSnapshot(boolean reset) {
        return this.stats.getSnapshot(reset);
    }

    public long getLastQueryTime() {
        return this.stats.getLastQueryTime();
    }

    ScalarDataReader<?> getSingleAttributeScalarType() {
        return this.sqlTree.getRootNode().getSingleAttributeReader();
    }

    public boolean isEmptyStats() {
        return this.stats.isEmpty();
    }

    TimedMetric createTimedMetric() {
        return MetricFactory.get().createTimedMetric(this.label);
    }

    void captureBindForQueryPlan(CQueryPredicates predicates, long executionTimeMicros) {
        long startNanos = System.nanoTime();
        try {
            DataBindCapture capture = this.bindCapture();
            predicates.bind(capture);
            this.bindCapture.setBind(capture.bindCapture(), executionTimeMicros, startNanos);
        }
        catch (SQLException e) {
            logger.error("Error capturing bind values", (Throwable)e);
        }
    }
}

