/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CountedValue;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.type.RsetDataReader;
import io.ebeaninternal.server.type.ScalarDataReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CQueryFetchSingleAttribute
implements SpiProfileTransactionEvent {
    private static final Logger logger = LoggerFactory.getLogger(CQueryFetchSingleAttribute.class);
    private final CQueryPlan queryPlan;
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private RsetDataReader dataReader;
    private PreparedStatement pstmt;
    private String bindLog;
    private long executionTimeMicros;
    private int rowCount;
    private final ScalarDataReader<?> reader;
    private final boolean containsCounts;
    private long profileOffset;

    CQueryFetchSingleAttribute(OrmQueryRequest<?> request, CQueryPredicates predicates, CQueryPlan queryPlan, boolean containsCounts) {
        this.request = request;
        this.queryPlan = queryPlan;
        this.query = request.getQuery();
        this.sql = queryPlan.getSql();
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
        this.containsCounts = containsCounts;
        this.reader = queryPlan.getSingleAttributeScalarType();
        this.query.setGeneratedSql(this.sql);
    }

    String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindAttr exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.getName()).append("] predicates[").append(this.predicates.getLogWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    List<Object> findList() throws SQLException {
        long startNano = System.nanoTime();
        try {
            this.prepareExecute();
            ArrayList<Object> result = new ArrayList<Object>();
            while (this.dataReader.next()) {
                Object value = this.reader.read(this.dataReader);
                if (this.containsCounts) {
                    value = new CountedValue(value, this.dataReader.getLong().longValue());
                }
                result.add(value);
                this.dataReader.resetColumnPosition();
                ++this.rowCount;
            }
            this.executionTimeMicros = (System.nanoTime() - startNano) / 1000L;
            this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            this.getTransaction().profileEvent(this);
            ArrayList<Object> arrayList = result;
            return arrayList;
        }
        finally {
            this.close();
        }
    }

    private SpiTransaction getTransaction() {
        return this.request.getTransaction();
    }

    String getBindLog() {
        return this.bindLog;
    }

    String getGeneratedSql() {
        return this.sql;
    }

    private void prepareExecute() throws SQLException {
        SpiTransaction t = this.getTransaction();
        this.profileOffset = t.profileOffset();
        Connection conn = t.getInternalConnection();
        this.pstmt = conn.prepareStatement(this.sql);
        if (this.query.getBufferFetchSizeHint() > 0) {
            this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
        }
        if (this.query.getTimeout() > 0) {
            this.pstmt.setQueryTimeout(this.query.getTimeout());
        }
        this.bindLog = this.predicates.bind(this.pstmt, conn);
        this.dataReader = new RsetDataReader(this.request.getDataTimeZone(), this.pstmt.executeQuery());
    }

    private void close() {
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            logger.error("Error closing DataReader", (Throwable)e);
        }
        JdbcClose.close((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public void profile() {
        this.getTransaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.getName(), this.rowCount, this.query.getProfileId());
    }

    Set<String> getDependentTables() {
        return this.queryPlan.getDependentTables();
    }
}

