/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist.dml;

import io.ebean.bean.EntityBean;
import io.ebeaninternal.api.ConcurrencyMode;
import io.ebeaninternal.api.SpiUpdatePlan;
import io.ebeaninternal.server.persist.dml.DmlHandler;
import io.ebeaninternal.server.persist.dmlbind.Bindable;
import java.sql.SQLException;

class UpdatePlan
implements SpiUpdatePlan {
    private final String key;
    private final ConcurrencyMode mode;
    private final String sql;
    private final Bindable set;
    private final long timeCreated;
    private final boolean emptySetClause;
    private long timeLastUsed;

    UpdatePlan(ConcurrencyMode mode, String sql, Bindable set) {
        this(null, mode, sql, set);
    }

    UpdatePlan(String key, ConcurrencyMode mode, String sql, Bindable set) {
        this.emptySetClause = sql == null;
        this.key = key;
        this.mode = mode;
        this.sql = sql;
        this.set = set;
        this.timeCreated = System.currentTimeMillis();
    }

    @Override
    public boolean isEmptySetClause() {
        return this.emptySetClause;
    }

    @Override
    public void bindSet(DmlHandler bind, EntityBean bean) throws SQLException {
        this.set.dmlBind(bind, bean);
        this.timeLastUsed = System.currentTimeMillis();
    }

    @Override
    public long getTimeCreated() {
        return this.timeCreated;
    }

    @Override
    public long getTimeLastUsed() {
        return this.timeLastUsed;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public ConcurrencyMode getMode() {
        return this.mode;
    }

    @Override
    public String getSql() {
        return this.sql;
    }

    @Override
    public Bindable getSet() {
        return this.set;
    }
}

