/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.persist;

import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.persist.MergeHandler;
import io.ebeaninternal.server.persist.MergeRequest;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

abstract class MergeNode {
    private final String fullPath;
    final BeanDescriptor<?> targetDescriptor;
    private Map<String, MergeNode> children;

    MergeNode(String fullPath, BeanPropertyAssoc<?> property) {
        this.fullPath = fullPath;
        this.targetDescriptor = property.getTargetDescriptor();
    }

    abstract void merge(MergeRequest var1);

    MergeNode addChild(String fullPath, String path) {
        MergeNode childNode = MergeHandler.createMergeNode(fullPath, this.targetDescriptor, path);
        if (this.children == null) {
            this.children = new LinkedHashMap<String, MergeNode>();
        }
        this.children.put(path, childNode);
        return childNode;
    }

    MergeNode get(String path) {
        if (this.children != null) {
            return this.children.get(path);
        }
        return null;
    }

    Map<Object, EntityBean> toMap(Collection outlines) {
        HashMap<Object, EntityBean> outlineMap = new HashMap<Object, EntityBean>();
        if (outlines != null) {
            for (Object out : outlines) {
                EntityBean outlineBean = (EntityBean)out;
                Object outlineId = this.targetDescriptor.getId(outlineBean);
                outlineMap.put(outlineId, outlineBean);
            }
        }
        return outlineMap;
    }

    void addSelectId(Query<?> query) {
        BeanProperty idProperty = this.targetDescriptor.getIdProperty();
        query.fetch(this.fullPath, idProperty.getName());
    }

    void cascade(EntityBean entityBean, EntityBean outlineBean, MergeRequest request) {
        if (this.children != null && !this.children.isEmpty()) {
            MergeRequest sub = request.sub(entityBean, outlineBean);
            for (MergeNode node : this.children.values()) {
                node.merge(sub);
            }
        }
    }
}

