/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.bean.EntityBean;
import io.ebean.plugin.ExpressionPath;
import io.ebeaninternal.api.NaturalKeyQueryData;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.server.el.ElPropertyValue;
import io.ebeaninternal.server.expression.AbstractValueExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.Op;
import java.io.IOException;
import java.util.Arrays;

public class SimpleExpression
extends AbstractValueExpression {
    private final Op type;

    public SimpleExpression(String propertyName, Op type, Object value) {
        super(propertyName, value);
        this.type = type;
    }

    @Override
    public Object getIdEqualTo(String idName) {
        if (this.type == Op.EQ && idName.equals(this.propName)) {
            return this.value();
        }
        return null;
    }

    @Override
    public boolean naturalKey(NaturalKeyQueryData<?> data) {
        if (this.type != Op.EQ) {
            return false;
        }
        return data.matchEq(this.propName, this.bindValue);
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (this.type == Op.BETWEEN) {
            throw new IllegalStateException("BETWEEN Not expected in SimpleExpression?");
        }
        ExpressionPath prop = context.getExpressionPath(this.propName);
        if (prop != null && prop.isAssocId()) {
            String idName = prop.getAssocIdExpression(this.propName, "");
            Object[] ids = prop.getAssocIdValues((EntityBean)this.value());
            if (ids == null || ids.length != 1) {
                throw new IllegalArgumentException("Expecting 1 Id value for " + idName + " but got " + Arrays.toString(ids));
            }
            context.writeSimple(this.type, idName, ids[0]);
        } else {
            context.writeSimple(this.type, this.propName, this.value());
        }
    }

    public final String getPropName() {
        return this.propName;
    }

    public boolean isOpEquals() {
        return Op.EQ == this.type;
    }

    public Object getValue() {
        return this.value();
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                Object[] ids = prop.getAssocIdValues((EntityBean)this.value());
                if (ids != null) {
                    for (Object id : ids) {
                        request.addBindValue(id);
                    }
                }
                return;
            }
            if (prop.isDbEncrypted()) {
                String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
                request.addBindEncryptKey(encryptKey);
            } else if (prop.isLocalEncrypted()) {
                Object bindVal = prop.localEncrypt(this.value());
                request.addBindEncryptKey(bindVal);
                return;
            }
        }
        request.addBindValue(this.value());
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null) {
            if (prop.isAssocId()) {
                request.append(prop.getAssocIdExpression(this.propName, this.type.bind()));
                return;
            }
            if (prop.isDbEncrypted()) {
                String dsql = prop.getBeanProperty().getDecryptProperty(this.propName);
                request.append(dsql).append(this.type.bind());
                return;
            }
        }
        request.append(this.propName).append(this.type.bind());
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append(this.type.name()).append("[").append(this.propName).append("]");
    }

    @Override
    public int queryBindHash() {
        return this.value().hashCode();
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        SimpleExpression that = (SimpleExpression)other;
        return this.value().equals(that.value());
    }
}

