/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DeployPropertyParser;
import io.ebeaninternal.server.deploy.DynamicPropertyAggregationFormula;
import io.ebeaninternal.server.deploy.DynamicPropertyAggregationFormulaMTO;
import io.ebeaninternal.server.el.ElPropertyDeploy;
import io.ebeaninternal.server.query.STreeProperty;
import io.ebeaninternal.server.type.ScalarType;

final class FormulaPropertyPath {
    private static final String[] AGG_FUNCTIONS = new String[]{"count", "max", "min", "avg", "sum"};
    private static final String DISTINCT_ = "distinct ";
    private final BeanDescriptor<?> descriptor;
    private final String formula;
    private final String outerFunction;
    private final String internalExpression;
    private final ElPropertyDeploy firstProp;
    private final String parsedAggregation;
    private boolean countDistinct;
    private String cast;
    private String alias;

    static STreeProperty create(BeanDescriptor<?> descriptor, String formula, String path) {
        return new FormulaPropertyPath(descriptor, formula, path).build();
    }

    FormulaPropertyPath(BeanDescriptor<?> descriptor, String formula, String path) {
        this.descriptor = descriptor;
        this.formula = formula;
        int openBracket = formula.indexOf(40);
        int closeBracket = formula.lastIndexOf(41);
        if (openBracket == -1 || closeBracket == -1) {
            throw new IllegalStateException("Unable to parse formula [" + formula + "]");
        }
        this.outerFunction = formula.substring(0, openBracket).trim();
        this.internalExpression = this.trimDistinct(formula.substring(openBracket + 1, closeBracket));
        if (closeBracket < formula.length() - 1) {
            this.parseSuffix(formula.substring(closeBracket + 1).trim());
        }
        DeployPropertyParser parser = descriptor.parser().setCatchFirst(true);
        String parsed = parser.parse(this.internalExpression);
        if (path != null) {
            parsed = parsed.replace("${}", "${" + path + "}");
        }
        this.parsedAggregation = this.buildFormula(parsed);
        this.firstProp = parser.getFirstProp();
    }

    private void parseSuffix(String suffix) {
        String[] split = suffix.split(" ");
        if (split.length == 1) {
            if (split[0].startsWith("::")) {
                this.cast = split[0].substring(2);
            } else {
                this.alias = split[0];
            }
        } else if (split.length == 2) {
            this.cast = "as".equals(split[0]) ? null : split[0].substring(2);
            this.alias = split[1];
        } else if (split.length == 3) {
            this.cast = split[0].substring(2);
            this.alias = split[2];
        }
    }

    private String trimDistinct(String propertyName) {
        if (propertyName.startsWith(DISTINCT_)) {
            this.countDistinct = true;
            return propertyName.substring(DISTINCT_.length());
        }
        return propertyName;
    }

    String outerFunction() {
        return this.outerFunction;
    }

    String internalExpression() {
        return this.internalExpression;
    }

    String cast() {
        return this.cast;
    }

    String alias() {
        return this.alias;
    }

    STreeProperty build() {
        if (this.cast != null) {
            ScalarType<?> scalarType = this.descriptor.getScalarType(this.cast);
            if (scalarType == null) {
                throw new IllegalStateException("Unable to find scalarType for cast of [" + this.cast + "] on formula [" + this.formula + "] for type " + this.descriptor);
            }
            return this.create(scalarType);
        }
        if (this.isCount()) {
            return this.create(this.descriptor.getScalarType(-5));
        }
        if (this.isConcat()) {
            return this.create(this.descriptor.getScalarType(12));
        }
        if (this.firstProp == null) {
            throw new IllegalStateException("unable to determine scalarType of formula [" + this.formula + "] for type " + this.descriptor + " - maybe use a cast like ::String ?");
        }
        BeanProperty property = this.firstProp.getBeanProperty();
        if (!property.isAssocId()) {
            return this.create(property.getScalarType());
        }
        return this.createManyToOne(property);
    }

    private DynamicPropertyAggregationFormula create(ScalarType<?> scalarType) {
        String logicalName = this.logicalName();
        return new DynamicPropertyAggregationFormula(logicalName, scalarType, this.parsedAggregation, this.isAggregate(), this.target(logicalName), this.alias);
    }

    private DynamicPropertyAggregationFormula createManyToOne(BeanProperty property) {
        String logicalName = this.logicalName();
        return new DynamicPropertyAggregationFormulaMTO((BeanPropertyAssocOne)property, logicalName, this.parsedAggregation, this.isAggregate(), this.target(logicalName), this.alias);
    }

    private BeanProperty target(String logicalName) {
        return this.descriptor._findBeanProperty(logicalName);
    }

    private String logicalName() {
        return this.alias == null ? this.internalExpression : this.alias;
    }

    private boolean isAggregate() {
        for (String aggFunction : AGG_FUNCTIONS) {
            if (!aggFunction.equals(this.outerFunction)) continue;
            return true;
        }
        return false;
    }

    private String buildFormula(String parsed) {
        if (this.countDistinct) {
            return "count(distinct " + parsed + ")";
        }
        return this.outerFunction + "(" + parsed + ")";
    }

    private boolean isCount() {
        return this.outerFunction.equals("count");
    }

    private boolean isConcat() {
        return this.outerFunction.equals("concat");
    }
}

