/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.core;

import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiSqlUpdate;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.lib.Str;
import io.ebeaninternal.server.persist.BatchControl;
import io.ebeaninternal.server.persist.PersistExecute;
import io.ebeaninternal.server.persist.TrimLogSql;

public final class PersistRequestUpdateSql
extends PersistRequest {
    private final SpiSqlUpdate updateSql;
    private int rowCount;
    private String bindLog;
    private SqlType sqlType;
    private String tableName;
    private boolean addBatch;
    private final boolean forceNoBatch;
    private boolean batchThisRequest;
    private boolean flushQueue;

    public PersistRequestUpdateSql(SpiEbeanServer server, SpiSqlUpdate sqlUpdate, SpiTransaction t, PersistExecute persistExecute, boolean forceNoBatch) {
        super(server, t, persistExecute, sqlUpdate.getLabel());
        this.type = PersistRequest.Type.UPDATESQL;
        this.updateSql = sqlUpdate;
        this.forceNoBatch = forceNoBatch;
        this.updateSql.reset();
    }

    public PersistRequestUpdateSql(SpiEbeanServer server, SpiSqlUpdate sqlUpdate, SpiTransaction t, PersistExecute persistExecute) {
        this(server, sqlUpdate, t, persistExecute, false);
    }

    @Override
    public void profile(long offset, int flushCount) {
        this.profileBase("su", offset, "", flushCount);
    }

    public int addBatch() {
        this.addBatch = true;
        return this.executeOrQueue();
    }

    public void executeAddBatch() {
        this.addBatch = true;
        this.persistExecute.executeSqlUpdate(this);
    }

    public void addToFlushQueue(boolean early) {
        BatchControl control = this.transaction.getBatchControl();
        if (control == null) {
            control = this.persistExecute.createBatchControl(this.transaction);
        }
        this.flushQueue = true;
        control.addToFlushQueue(this, early);
    }

    @Override
    public boolean isFlushQueue() {
        return this.flushQueue;
    }

    @Override
    public int executeNow() {
        return this.persistExecute.executeSqlUpdate(this);
    }

    @Override
    public boolean isBatchThisRequest() {
        return !this.forceNoBatch && (this.addBatch || super.isBatchThisRequest());
    }

    @Override
    public int executeOrQueue() {
        return this.executeStatement();
    }

    public SpiSqlUpdate getUpdateSql() {
        return this.updateSql;
    }

    @Override
    public void checkRowCount(int count) {
        this.rowCount = count;
    }

    @Override
    public void setGeneratedKey(Object idValue) {
        this.updateSql.setGeneratedKey(idValue);
    }

    public boolean isGetGeneratedKeys() {
        return this.updateSql.isGetGeneratedKeys();
    }

    public void setType(SqlType sqlType, String tableName) {
        this.sqlType = sqlType;
        this.tableName = tableName;
    }

    public void setBindLog(String bindLog) {
        this.bindLog = bindLog;
    }

    @Override
    public void startBind(boolean batchThisRequest) {
        this.batchThisRequest = batchThisRequest;
        super.startBind(batchThisRequest);
    }

    public void logSqlBatchBind() {
        if (this.transaction.isLogSql()) {
            this.transaction.logSql(Str.add(" -- bind(", this.bindLog, ")"));
        }
    }

    @Override
    public void postExecute() {
        if (this.startNanos > 0L) {
            this.persistExecute.collectSqlUpdate(this.label, this.startNanos);
        }
        if (this.transaction.isLogSql() && !this.batchThisRequest) {
            this.transaction.logSql(Str.add(TrimLogSql.trim(this.updateSql.getGeneratedSql()), "; -- bind(", this.bindLog, ") rows(", String.valueOf(this.rowCount), ")"));
        }
        if (this.updateSql.isAutoTableMod()) {
            switch (this.sqlType) {
                case SQL_INSERT: {
                    this.transaction.getEvent().add(this.tableName, true, false, false);
                    break;
                }
                case SQL_UPDATE: {
                    this.transaction.getEvent().add(this.tableName, false, true, false);
                    break;
                }
                case SQL_DELETE: {
                    this.transaction.getEvent().add(this.tableName, false, false, true);
                    break;
                }
                case SQL_UNKNOWN: {
                    this.transaction.markNotQueryOnly();
                }
            }
        }
    }

    public static enum SqlType {
        SQL_UPDATE,
        SQL_DELETE,
        SQL_INSERT,
        SQL_UNKNOWN;

    }
}

