/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.type;

import io.ebean.config.JsonConfig;
import io.ebeaninternal.server.type.ScalarTypeBaseDateTime;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;

final class ScalarTypeZonedDateTime
extends ScalarTypeBaseDateTime<ZonedDateTime> {
    private final ZoneId zoneId;

    ScalarTypeZonedDateTime(JsonConfig.DateTime mode, ZoneId zoneId) {
        super(mode, ZonedDateTime.class, false, 93);
        this.zoneId = zoneId;
    }

    @Override
    protected String toJsonNanos(ZonedDateTime value) {
        return this.toJsonNanos(value.toEpochSecond(), value.getNano());
    }

    @Override
    protected String toJsonISO8601(ZonedDateTime value) {
        return value.toInstant().toString();
    }

    @Override
    public long convertToMillis(ZonedDateTime value) {
        return value.toInstant().toEpochMilli();
    }

    @Override
    public ZonedDateTime convertFromMillis(long systemTimeMillis) {
        return this.convertFromInstant(Instant.ofEpochMilli(systemTimeMillis));
    }

    @Override
    public ZonedDateTime convertFromTimestamp(Timestamp ts) {
        return this.convertFromInstant(ts.toInstant());
    }

    @Override
    public ZonedDateTime convertFromInstant(Instant ts) {
        return ZonedDateTime.ofInstant(ts, this.zoneId);
    }

    @Override
    public Timestamp convertToTimestamp(ZonedDateTime t) {
        return Timestamp.from(t.toInstant());
    }

    public Object toJdbcType(Object value) {
        if (value instanceof Timestamp) {
            return value;
        }
        return this.convertToTimestamp((ZonedDateTime)value);
    }

    public ZonedDateTime toBeanType(Object value) {
        if (value instanceof Timestamp) {
            return this.convertFromTimestamp((Timestamp)value);
        }
        return (ZonedDateTime)value;
    }
}

