/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.query;

import io.ebean.CancelableQuery;
import io.ebean.QueryIterator;
import io.ebean.Transaction;
import io.ebean.Version;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.NodeUsageCollector;
import io.ebean.bean.NodeUsageListener;
import io.ebean.bean.ObjectGraphNode;
import io.ebean.bean.PersistenceContext;
import io.ebean.core.type.DataReader;
import io.ebean.event.readaudit.ReadEvent;
import io.ebean.util.JdbcClose;
import io.ebeaninternal.api.SpiProfileTransactionEvent;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.server.autotune.ProfilingListener;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.core.SpiOrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanCollectionHelpFactory;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DbReadContext;
import io.ebeaninternal.server.query.CQueryCollectionAdd;
import io.ebeaninternal.server.query.CQueryCollectionAddNoop;
import io.ebeaninternal.server.query.CQueryIteratorSimple;
import io.ebeaninternal.server.query.CQueryIteratorWithBuffer;
import io.ebeaninternal.server.query.CQueryPlan;
import io.ebeaninternal.server.query.CQueryPredicates;
import io.ebeaninternal.server.query.STreePropertyAssocMany;
import io.ebeaninternal.server.query.SqlTree;
import io.ebeaninternal.server.query.SqlTreeRoot;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.locks.ReentrantLock;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CQuery<T>
implements DbReadContext,
CancelableQuery,
SpiProfileTransactionEvent {
    private static final Logger logger = LoggerFactory.getLogger(CQuery.class);
    private static final CQueryCollectionAddNoop NOOP_ADD = new CQueryCollectionAddNoop();
    private final ReentrantLock lock = new ReentrantLock();
    private int rowCount;
    private int loadedBeanCount;
    private boolean noMoreRows;
    private EntityBean nextBean;
    private EntityBean currentBean;
    private boolean hasNextCache;
    private final BeanPropertyAssocMany<?> lazyLoadManyProperty;
    private Object lazyLoadParentId;
    private EntityBean lazyLoadParentBean;
    private final BeanCollection<T> collection;
    private final CQueryCollectionAdd help;
    private final OrmQueryRequest<T> request;
    private final BeanDescriptor<T> desc;
    private final SpiQuery<T> query;
    private final boolean disableLazyLoading;
    private Map<String, String> currentPathMap;
    private String currentPrefix;
    private final CQueryPredicates predicates;
    private final boolean rawSql;
    private final String sql;
    private final String logWhereSql;
    private final SqlTreeRoot rootNode;
    private final STreePropertyAssocMany manyProperty;
    private DataReader dataReader;
    private PreparedStatement pstmt;
    private String bindLog;
    private final CQueryPlan queryPlan;
    private final SpiQuery.Mode queryMode;
    private final boolean autoTuneProfiling;
    private final ObjectGraphNode objectGraphNode;
    private final ProfilingListener profilingListener;
    private final WeakReference<NodeUsageListener> profilingListenerRef;
    private final Boolean readOnly;
    private long profileOffset;
    private long startNano;
    private long executionTimeMicros;
    private final boolean audit;
    private boolean auditFindIterate;
    private List<Object> auditIds;

    public CQuery(OrmQueryRequest<T> request, CQueryPredicates predicates, CQueryPlan queryPlan) {
        this.request = request;
        this.audit = request.isAuditReads();
        this.queryPlan = queryPlan;
        this.query = request.getQuery();
        this.queryMode = this.query.getMode();
        this.lazyLoadManyProperty = this.query.getLazyLoadMany();
        this.readOnly = request.isReadOnly();
        this.disableLazyLoading = this.query.isDisableLazyLoading();
        this.objectGraphNode = this.query.getParentNode();
        this.profilingListener = this.query.getProfilingListener();
        this.autoTuneProfiling = this.profilingListener != null;
        this.profilingListenerRef = this.autoTuneProfiling ? new WeakReference<ProfilingListener>(this.profilingListener) : null;
        this.query.setGeneratedSql(queryPlan.getSql());
        SqlTree sqlTree = queryPlan.getSqlTree();
        this.rootNode = sqlTree.getRootNode();
        this.manyProperty = sqlTree.getManyProperty();
        this.sql = queryPlan.getSql();
        this.rawSql = queryPlan.isRawSql();
        this.logWhereSql = queryPlan.getLogWhereSql();
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
        this.help = this.lazyLoadManyProperty != null ? NOOP_ADD : this.createHelp(request);
        this.collection = this.help != null ? this.help.createEmptyNoParent() : null;
    }

    private CQueryCollectionAdd<T> createHelp(OrmQueryRequest<T> request) {
        if (request.isFindById()) {
            return null;
        }
        SpiQuery.Type manyType = request.getQuery().getType();
        if (manyType == null) {
            return null;
        }
        return BeanCollectionHelpFactory.create(manyType, request);
    }

    @Override
    public boolean isDraftQuery() {
        return this.query.isAsDraft();
    }

    @Override
    public boolean isDisableLazyLoading() {
        return this.disableLazyLoading;
    }

    @Override
    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public void propagateState(Object e) {
        if (Boolean.TRUE.equals(this.readOnly) && e instanceof EntityBean) {
            ((EntityBean)e)._ebean_getIntercept().setReadOnly(true);
        }
    }

    @Override
    public DataReader getDataReader() {
        return this.dataReader;
    }

    @Override
    public SpiQuery.Mode getQueryMode() {
        return this.queryMode;
    }

    public CQueryPredicates getPredicates() {
        return this.predicates;
    }

    SpiOrmQueryRequest<?> getQueryRequest() {
        return this.request;
    }

    public void cancel() {
        this.lock.lock();
        try {
            JdbcClose.cancel((Statement)this.pstmt);
        }
        finally {
            this.lock.unlock();
        }
    }

    boolean prepareBindExecuteQueryForwardOnly(boolean dbPlatformForwardOnlyHint) throws SQLException {
        return this.prepareBindExecuteQueryWithOption(dbPlatformForwardOnlyHint);
    }

    boolean prepareBindExecuteQuery() throws SQLException {
        return this.prepareBindExecuteQueryWithOption(false);
    }

    private boolean prepareBindExecuteQueryWithOption(boolean forwardOnlyHint) throws SQLException {
        ResultSet resultSet = this.prepareResultSet(forwardOnlyHint);
        if (resultSet == null) {
            return false;
        }
        this.dataReader = this.queryPlan.createDataReader(resultSet);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ResultSet prepareResultSet(boolean forwardOnlyHint) throws SQLException {
        this.lock.lock();
        try {
            ResultSet suppliedResultSet;
            this.query.checkCancelled();
            this.startNano = System.nanoTime();
            Transaction t = this.request.getTransaction();
            this.profileOffset = t.profileOffset();
            if (this.query.isRawSql() && (suppliedResultSet = this.query.getRawSql().getResultSet()) != null) {
                this.bindLog = "";
                ResultSet resultSet = suppliedResultSet;
                return resultSet;
            }
            Connection conn = t.getInternalConnection();
            if (forwardOnlyHint) {
                this.pstmt = conn.prepareStatement(this.sql, 1003, 1007);
                this.pstmt.setFetchSize(Integer.MIN_VALUE);
            } else {
                this.pstmt = conn.prepareStatement(this.sql);
            }
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            if (this.query.getBufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
            }
            this.bindLog = this.predicates.bind(this.queryPlan.bindEncryptedProperties(this.pstmt, conn));
        }
        finally {
            this.lock.unlock();
        }
        ResultSet ret = this.pstmt.executeQuery();
        this.query.checkCancelled();
        return ret;
    }

    public void close() {
        try {
            if (this.auditFindIterate && this.auditIds != null && !this.auditIds.isEmpty()) {
                this.auditIterateLogMessage();
            }
        }
        catch (Throwable e) {
            logger.error("Error logging read audit logs", e);
        }
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            logger.error("Error closing dataReader", (Throwable)e);
        }
        JdbcClose.close((Statement)this.pstmt);
        this.pstmt = null;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.request.getPersistenceContext();
    }

    @Override
    public void setLazyLoadedChildBean(EntityBean bean, Object lazyLoadParentId) {
        if (lazyLoadParentId != null) {
            if (!lazyLoadParentId.equals(this.lazyLoadParentId)) {
                this.lazyLoadParentBean = (EntityBean)this.lazyLoadManyProperty.getBeanDescriptor().contextGet(this.getPersistenceContext(), lazyLoadParentId);
                this.lazyLoadParentId = lazyLoadParentId;
            }
            this.lazyLoadManyProperty.addBeanToCollectionWithCreate(this.lazyLoadParentBean, bean, true);
        }
    }

    private boolean readNextBean() throws SQLException {
        if (!this.moveToNextRow()) {
            if (this.currentBean == null) {
                this.nextBean = null;
                return false;
            }
            this.nextBean = this.currentBean;
            ++this.loadedBeanCount;
            return true;
        }
        ++this.loadedBeanCount;
        if (this.manyProperty == null) {
            this.nextBean = this.rootNode.load(this);
            return true;
        }
        if (this.nextBean == null) {
            this.nextBean = this.rootNode.load(this);
        } else {
            this.nextBean = this.currentBean;
            this.request.persistenceContextAdd(this.nextBean);
            if (this.checkForDifferentBean()) {
                return true;
            }
        }
        this.readUntilDifferentBeanStarted();
        return true;
    }

    private void readUntilDifferentBeanStarted() throws SQLException {
        while (this.moveToNextRow()) {
            if (!this.checkForDifferentBean()) continue;
            return;
        }
    }

    private boolean checkForDifferentBean() throws SQLException {
        this.currentBean = this.rootNode.load(this);
        return this.currentBean != this.nextBean;
    }

    private boolean moveToNextRow() throws SQLException {
        if (!this.dataReader.next()) {
            this.noMoreRows = true;
            return false;
        }
        ++this.rowCount;
        return true;
    }

    long getQueryExecutionTimeMicros() {
        return this.executionTimeMicros;
    }

    boolean readBean() throws SQLException {
        boolean result = this.hasNext();
        this.updateExecutionStatistics();
        return result;
    }

    EntityBean next() {
        if (this.audit) {
            this.auditNextBean();
        }
        this.hasNextCache = false;
        if (this.nextBean == null) {
            throw new NoSuchElementException();
        }
        return this.nextBean;
    }

    boolean hasNext() throws SQLException {
        this.lock.lock();
        try {
            this.query.checkCancelled();
            if (this.noMoreRows) {
                boolean bl = false;
                return bl;
            }
            if (this.hasNextCache) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.hasNextCache = this.readNextBean();
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    List<Version<T>> readVersions() throws SQLException {
        Version<T> version;
        ArrayList<Version<T>> versionList = new ArrayList<Version<T>>();
        while ((version = this.readNextVersion()) != null) {
            versionList.add(version);
        }
        this.updateExecutionStatistics();
        return versionList;
    }

    private Version<T> readNextVersion() throws SQLException {
        if (this.moveToNextRow()) {
            return this.rootNode.loadVersion(this);
        }
        return null;
    }

    BeanCollection<T> readCollection() throws SQLException {
        while (this.hasNext()) {
            this.help.add(this.collection, this.next(), false);
        }
        this.updateExecutionStatistics();
        return this.collection;
    }

    private void updateExecutionStatistics() {
        this.updateStatistics();
        this.request.slowQueryCheck(this.executionTimeMicros, this.rowCount);
    }

    void updateExecutionStatisticsIterator() {
        this.updateStatistics();
    }

    long micros() {
        return (System.nanoTime() - this.startNano) / 1000L;
    }

    private void updateStatistics() {
        try {
            this.executionTimeMicros = this.micros();
            if (this.autoTuneProfiling) {
                this.profilingListener.collectQueryInfo(this.objectGraphNode, this.loadedBeanCount, this.executionTimeMicros);
            }
            if (this.queryPlan.executionTime(this.executionTimeMicros)) {
                this.queryPlan.captureBindForQueryPlan(this.predicates, this.executionTimeMicros);
            }
            this.getTransaction().profileEvent(this);
        }
        catch (Exception e) {
            logger.error("Error updating execution statistics", (Throwable)e);
        }
    }

    @Override
    public void profile() {
        this.getTransaction().profileStream().addQueryEvent(this.query.profileEventId(), this.profileOffset, this.desc.getName(), this.loadedBeanCount, this.query.getProfileId());
    }

    QueryIterator<T> readIterate(int bufferSize, OrmQueryRequest<T> request) {
        if (bufferSize == 1) {
            return new CQueryIteratorSimple<T>(this, request);
        }
        return new CQueryIteratorWithBuffer<T>(this, request, bufferSize);
    }

    String getLoadedRowDetail() {
        if (this.manyProperty == null) {
            return String.valueOf(this.rowCount);
        }
        return this.loadedBeanCount + ":" + this.rowCount;
    }

    @Override
    public void registerBeanInherit(BeanPropertyAssocOne<?> property, EntityBeanIntercept ebi) {
        String path = this.getPath(property.getName());
        this.request.getGraphContext().register(path, ebi, property);
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi) {
        path = this.getPath(path);
        this.request.getGraphContext().register(path, ebi);
    }

    @Override
    public void register(BeanPropertyAssocMany<?> many, BeanCollection<?> bc) {
        String path = this.getPath(many.getName());
        this.request.getGraphContext().register(path, many, bc);
    }

    @Override
    public boolean isRawSql() {
        return this.rawSql;
    }

    String getLogWhereSql() {
        return this.logWhereSql;
    }

    @Override
    public STreePropertyAssocMany getManyProperty() {
        return this.manyProperty;
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public SpiTransaction getTransaction() {
        return this.request.getTransaction();
    }

    String getBeanName() {
        return this.desc.getName();
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    PersistenceException createPersistenceException(SQLException e) {
        return this.request.translate(this.bindLog, this.sql, e);
    }

    @Override
    public boolean isAutoTuneProfiling() {
        return this.autoTuneProfiling && this.query.isUsageProfiling();
    }

    private String getPath(String propertyName) {
        if (this.currentPrefix == null) {
            return propertyName;
        }
        if (propertyName == null) {
            return this.currentPrefix;
        }
        String path = this.currentPathMap.get(propertyName);
        if (path != null) {
            return path;
        }
        return this.currentPrefix + "." + propertyName;
    }

    @Override
    public void profileBean(EntityBeanIntercept ebi, String prefix) {
        ObjectGraphNode node = this.request.getGraphContext().getObjectGraphNode(prefix);
        ebi.setNodeUsageCollector(new NodeUsageCollector(node, this.profilingListenerRef));
    }

    @Override
    public void setCurrentPrefix(String currentPrefix, Map<String, String> currentPathMap) {
        this.currentPrefix = currentPrefix;
        this.currentPathMap = currentPathMap;
    }

    void auditFind(EntityBean bean) {
        if (bean != null) {
            this.desc.readAuditBean(this.queryPlan.getAuditQueryKey(), this.bindLog, bean);
        }
    }

    void auditFindMany() {
        if (this.auditIds != null && !this.auditIds.isEmpty()) {
            ReadEvent futureReadEvent = this.query.getFutureFetchAudit();
            if (futureReadEvent == null) {
                this.desc.readAuditMany(this.queryPlan.getAuditQueryKey(), this.bindLog, this.auditIds);
            } else {
                futureReadEvent.setQueryKey(this.queryPlan.getAuditQueryKey());
                futureReadEvent.setBindLog(this.bindLog);
                futureReadEvent.setIds(this.auditIds);
                this.desc.readAuditFutureMany(futureReadEvent);
            }
        }
    }

    void auditFindIterate() {
        this.auditFindIterate = true;
    }

    private void auditIterateLogMessage() {
        this.desc.readAuditMany(this.queryPlan.getAuditQueryKey(), this.bindLog, this.auditIds);
        this.auditIds = null;
    }

    private void auditNextBean() {
        if (this.auditIds == null) {
            this.auditIds = new ArrayList<Object>(100);
        }
        this.auditIds.add(this.desc.getIdForJson(this.nextBean));
        if (this.auditFindIterate && this.auditIds.size() >= 100) {
            this.auditIterateLogMessage();
        }
    }

    PreparedStatement getPstmt() {
        return this.pstmt;
    }

    @Override
    public void handleLoadError(String fullName, Exception e) {
        this.query.handleLoadError(fullName, e);
    }

    public Set<String> getDependentTables() {
        return this.queryPlan.getDependentTables();
    }
}

