/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.loadcontext;

import io.ebean.CacheMode;
import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebeaninternal.api.LoadBeanBuffer;
import io.ebeaninternal.api.LoadBeanContext;
import io.ebeaninternal.api.LoadBeanRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.core.OrmQueryRequest;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.loadcontext.DLoadBaseContext;
import io.ebeaninternal.server.loadcontext.DLoadContext;
import io.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;

final class DLoadBeanContext
extends DLoadBaseContext
implements LoadBeanContext {
    private final boolean cache;
    private List<LoadBuffer> bufferList;
    private LoadBuffer currentBuffer;

    DLoadBeanContext(DLoadContext parent, BeanDescriptor<?> desc, String path, OrmQueryProperties queryProps) {
        super(parent, desc, path, queryProps);
        this.bufferList = !this.queryFetch ? null : new ArrayList();
        this.currentBuffer = this.createBuffer(this.batchSize);
        this.cache = queryProps != null && queryProps.isCache();
    }

    @Override
    public void register(BeanPropertyAssocMany<?> many, BeanCollection<?> collection) {
        String path = this.fullPath + "." + many.getName();
        this.parent.register(path, many, collection);
    }

    public void clear() {
        if (this.bufferList != null) {
            this.bufferList.clear();
        }
        this.currentBuffer = this.createBuffer(this.batchSize);
    }

    private void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
        if (this.cache) {
            query.setBeanCacheMode(CacheMode.ON);
        }
        this.setLabel(query);
        this.parent.propagateQueryState(query, this.desc.isDocStoreMapped());
        query.setParentNode(this.objectGraphNode);
        query.setLazyLoadProperty(lazyLoadProperty);
        if (this.queryProps != null) {
            this.queryProps.configureBeanQuery(query);
        }
    }

    protected void register(EntityBeanIntercept ebi) {
        if (this.currentBuffer.isFull()) {
            this.currentBuffer = this.createBuffer(this.batchSize);
        }
        ebi.setBeanLoader((BeanLoader)this.currentBuffer, this.getPersistenceContext());
        this.currentBuffer.add(ebi);
    }

    private LoadBuffer createBuffer(int size) {
        LoadBuffer buffer = new LoadBuffer(this, size);
        if (this.bufferList != null) {
            this.bufferList.add(buffer);
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void loadSecondaryQuery(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (!this.queryFetch) {
            throw new IllegalStateException("Not expecting loadSecondaryQuery() to be called?");
        }
        this.lock.lock();
        try {
            if (this.bufferList != null) {
                for (LoadBuffer loadBuffer : this.bufferList) {
                    if (!loadBuffer.list.isEmpty()) {
                        this.parent.getEbeanServer().loadBean(new LoadBeanRequest(loadBuffer, parentRequest));
                    }
                    if (forEach) {
                        this.clear();
                        continue;
                    }
                    this.bufferList = null;
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    static class LoadBuffer
    implements BeanLoader,
    LoadBeanBuffer {
        private final ReentrantLock bufferLock = new ReentrantLock();
        private final DLoadBeanContext context;
        private final int batchSize;
        private final List<EntityBeanIntercept> list;
        private PersistenceContext persistenceContext;

        LoadBuffer(DLoadBeanContext context, int batchSize) {
            this.context = context;
            this.batchSize = batchSize;
            this.list = new ArrayList<EntityBeanIntercept>(batchSize);
        }

        public Lock lock() {
            this.bufferLock.lock();
            return this.bufferLock;
        }

        @Override
        public int getBatchSize() {
            return this.batchSize;
        }

        public boolean isFull() {
            return this.batchSize == this.list.size();
        }

        public void add(EntityBeanIntercept ebi) {
            if (this.persistenceContext == null) {
                this.persistenceContext = ebi.getPersistenceContext();
            }
            this.list.add(ebi);
        }

        @Override
        public List<EntityBeanIntercept> getBatch() {
            return this.list;
        }

        public String getName() {
            return this.context.serverName;
        }

        @Override
        public String getFullPath() {
            return this.context.fullPath;
        }

        @Override
        public BeanDescriptor<?> getBeanDescriptor() {
            return this.context.desc;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return this.persistenceContext;
        }

        @Override
        public void configureQuery(SpiQuery<?> query, String lazyLoadProperty) {
            this.context.configureQuery(query, lazyLoadProperty);
        }

        public void loadBean(EntityBeanIntercept ebi) {
            if (this.context.desc.lazyLoadMany(ebi, this.context)) {
                return;
            }
            if (this.list.isEmpty()) {
                this.list.add(ebi);
            } else if (this.context.hitCache) {
                Set<EntityBeanIntercept> hits = this.context.desc.cacheBeanLoadAll(this.list, this.persistenceContext, ebi.getLazyLoadPropertyIndex(), ebi.getLazyLoadProperty());
                this.list.removeAll(hits);
                if (this.list.isEmpty() || hits.contains(ebi)) {
                    return;
                }
            }
            LoadBeanRequest req = new LoadBeanRequest(this, ebi, this.context.hitCache);
            this.context.desc.getEbeanServer().loadBean(req);
            this.list.clear();
        }
    }
}

