/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebeaninternal.server.expression.RawExpression;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

final class RawExpressionBuilder {
    private static final String BP_1 = "?1";
    private static final String[] BP = new String[]{"?1", "?2", "?3", "?4", "?5", "?6", "?7", "?8", "?9", "?10", "?11", "?12", "?13", "?14", "?15", "?16", "?17", "?18", "?19", "?20"};
    private final String expanded;
    private final List<Object> params = new ArrayList<Object>();

    static RawExpression buildSingle(String raw, Object value) {
        if (RawExpressionBuilder.isExpand(value, raw, BP_1)) {
            Collection val = (Collection)value;
            raw = raw.replace(BP_1, RawExpressionBuilder.expand(val));
            return new RawExpression(raw, val.toArray());
        }
        return new RawExpression(raw, new Object[]{value});
    }

    static RawExpression build(String raw, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            if (!RawExpressionBuilder.isExpand(values[i], raw, RawExpressionBuilder.match(i))) continue;
            return new RawExpressionBuilder(raw, values).build();
        }
        return new RawExpression(raw, values);
    }

    private static boolean isExpand(Object value, String raw, String bindMatch) {
        return value instanceof Collection && raw.contains(bindMatch);
    }

    private static String match(int i) {
        if (i < 20) {
            return BP[i];
        }
        return "?" + (i + 1);
    }

    private static String expand(Collection values) {
        StringBuilder sqlExpand = new StringBuilder(values.size() * 2);
        for (int i = 0; i < values.size(); ++i) {
            if (i > 0) {
                sqlExpand.append(",");
            }
            sqlExpand.append("?");
        }
        return sqlExpand.toString();
    }

    private RawExpressionBuilder(String raw, Object[] values) {
        for (int i = 0; i < values.length; ++i) {
            String match = RawExpressionBuilder.match(i);
            if (!RawExpressionBuilder.isExpand(values[i], raw, match)) {
                this.params.add(values[i]);
                continue;
            }
            Collection val = (Collection)values[i];
            this.params.addAll(val);
            raw = raw.replace(match, RawExpressionBuilder.expand(val));
        }
        this.expanded = raw;
    }

    private RawExpression build() {
        return new RawExpression(this.expanded, this.params.toArray());
    }
}

