/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.expression;

import io.ebean.event.BeanQueryRequest;
import io.ebeaninternal.api.BindValuesKey;
import io.ebeaninternal.api.SpiEbeanServer;
import io.ebeaninternal.api.SpiExpression;
import io.ebeaninternal.api.SpiExpressionRequest;
import io.ebeaninternal.api.SpiQuery;
import io.ebeaninternal.server.expression.AbstractExpression;
import io.ebeaninternal.server.expression.DocQueryContext;
import io.ebeaninternal.server.expression.UnsupportedDocStoreExpression;
import io.ebeaninternal.server.query.CQuery;
import java.io.IOException;
import java.util.List;

final class InQueryExpression
extends AbstractExpression
implements UnsupportedDocStoreExpression {
    private final boolean not;
    private final SpiQuery<?> subQuery;
    private List<Object> bindParams;
    private String sql;

    InQueryExpression(String propertyName, SpiQuery<?> subQuery, boolean not) {
        super(propertyName);
        this.subQuery = subQuery;
        this.not = not;
    }

    InQueryExpression(String propertyName, boolean not, String sql, List<Object> bindParams) {
        super(propertyName);
        this.subQuery = null;
        this.not = not;
        this.sql = sql;
        this.bindParams = bindParams;
    }

    @Override
    public void simplify() {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        throw new IllegalStateException("Not supported");
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        CQuery<?> subQuery = this.compileSubQuery(request);
        this.bindParams = subQuery.getPredicates().getWhereExprBindValues();
        this.sql = subQuery.getGeneratedSql().replace('\n', ' ');
    }

    @Override
    public void queryPlanHash(StringBuilder builder) {
        builder.append("InQuery[").append(this.propName).append(" not:").append(this.not).append(" sql:").append(this.sql).append(" ?:").append(this.bindParams.size()).append("]");
    }

    private CQuery<?> compileSubQuery(BeanQueryRequest<?> queryRequest) {
        SpiEbeanServer ebeanServer = (SpiEbeanServer)queryRequest.getEbeanServer();
        return ebeanServer.compileQuery(SpiQuery.Type.SQ_IN, this.subQuery, queryRequest.getTransaction());
    }

    @Override
    public void queryBindKey(BindValuesKey key) {
        this.subQuery.queryBindKey(key);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.append(" (").append(this.propName).append(")");
        if (this.not) {
            request.append(" not");
        }
        request.append(" in (");
        request.append(this.sql);
        request.append(")");
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (Object bindParam : this.bindParams) {
            request.addBindValue(bindParam);
        }
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InQueryExpression that = (InQueryExpression)other;
        if (this.bindParams.size() != that.bindParams.size()) {
            return false;
        }
        for (int i = 0; i < this.bindParams.size(); ++i) {
            if (this.bindParams.get(i).equals(that.bindParams.get(i))) continue;
            return false;
        }
        return true;
    }
}

