/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.executor;

import io.ebeaninternal.api.SpiBackgroundExecutor;
import io.ebeaninternal.server.executor.DaemonScheduleThreadPool;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.slf4j.MDC;

public final class DefaultBackgroundExecutor
implements SpiBackgroundExecutor {
    private final ScheduledExecutorService executor;

    public DefaultBackgroundExecutor(int schedulePoolSize, int shutdownWaitSeconds, String namePrefix) {
        this.executor = new DaemonScheduleThreadPool(schedulePoolSize, shutdownWaitSeconds, namePrefix);
    }

    <T> Callable<T> wrapMDC(Callable<T> task) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap((Map)map);
            try {
                Object v = task.call();
                return v;
            }
            finally {
                MDC.clear();
            }
        };
    }

    Runnable wrapMDC(Runnable task) {
        Map map = MDC.getCopyOfContextMap();
        if (map == null) {
            return task;
        }
        return () -> {
            MDC.setContextMap((Map)map);
            try {
                task.run();
            }
            finally {
                MDC.clear();
            }
        };
    }

    public <T> Future<T> submit(Callable<T> task) {
        return this.executor.submit(this.wrapMDC(task));
    }

    public Future<?> submit(Runnable task) {
        return this.executor.submit(this.wrapMDC(task));
    }

    public void execute(Runnable task) {
        this.submit(task);
    }

    public void executePeriodically(Runnable task, long delay, TimeUnit unit) {
        this.executor.scheduleWithFixedDelay(this.wrapMDC(task), delay, delay, unit);
    }

    public void executePeriodically(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        this.executor.scheduleWithFixedDelay(this.wrapMDC(task), initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleWithFixedDelay(this.wrapMDC(task), initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long initialDelay, long delay, TimeUnit unit) {
        return this.executor.scheduleAtFixedRate(this.wrapMDC(task), initialDelay, delay, unit);
    }

    public ScheduledFuture<?> schedule(Runnable task, long delay, TimeUnit unit) {
        return this.executor.schedule(this.wrapMDC(task), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> task, long delay, TimeUnit unit) {
        return this.executor.schedule(this.wrapMDC(task), delay, unit);
    }

    @Override
    public void shutdown() {
        this.executor.shutdown();
    }
}

