/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.Query;
import io.ebean.bean.EntityBean;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanProperty;
import io.ebeaninternal.server.deploy.BeanPropertyAssoc;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import java.util.ArrayList;

final class BeanDescriptorDraftHelp<T> {
    private final BeanDescriptor<T> desc;
    private final BeanProperty draftDirty;
    private final BeanProperty[] resetProperties;

    BeanDescriptorDraftHelp(BeanDescriptor<T> desc) {
        this.desc = desc;
        this.draftDirty = desc.getDraftDirty();
        this.resetProperties = this.resetProperties();
    }

    private BeanProperty[] resetProperties() {
        ArrayList<BeanProperty> list = new ArrayList<BeanProperty>();
        for (BeanProperty prop : this.desc.propertiesNonMany()) {
            if (!prop.isDraftReset()) continue;
            list.add(prop);
        }
        return list.toArray(new BeanProperty[0]);
    }

    boolean draftReset(T draftBean) {
        EntityBean draftEntityBean = (EntityBean)draftBean;
        if (this.draftDirty != null) {
            this.draftDirty.setValueIntercept(draftEntityBean, false);
        }
        for (BeanProperty resetProperty : this.resetProperties) {
            resetProperty.setValueIntercept(draftEntityBean, null);
        }
        return draftEntityBean._ebean_getIntercept().isDirty();
    }

    public T publish(T draftBean, T liveBean) {
        if (liveBean == null) {
            liveBean = this.desc.createEntityBean();
        }
        EntityBean draft = (EntityBean)draftBean;
        EntityBean live = (EntityBean)liveBean;
        BeanProperty idProperty = this.desc.getIdProperty();
        if (idProperty != null) {
            idProperty.publish(draft, live);
        }
        for (BeanProperty beanProperty : this.desc.propertiesNonMany()) {
            beanProperty.publish(draft, live);
        }
        for (BeanProperty beanProperty : this.desc.propertiesMany()) {
            if (!((BeanPropertyAssoc)beanProperty).getTargetDescriptor().isDraftable()) continue;
            ((BeanPropertyAssocMany)beanProperty).publishMany(draft, live);
        }
        return (T)liveBean;
    }

    void draftQueryOptimise(Query<T> query) {
        for (BeanPropertyAssocOne<?> beanPropertyAssocOne : this.desc.propertiesOne()) {
            if (!beanPropertyAssocOne.getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(beanPropertyAssocOne.getName());
        }
        for (BeanPropertyAssoc beanPropertyAssoc : this.desc.propertiesMany()) {
            if (!beanPropertyAssoc.getTargetDescriptor().isDraftableElement()) continue;
            query.fetch(beanPropertyAssoc.getName());
        }
    }
}

