/*
 * Decompiled with CFR 0.152.
 */
package io.ebeaninternal.server.deploy;

import io.ebean.bean.BeanCollection;
import io.ebean.bean.BeanLoader;
import io.ebean.bean.EntityBean;
import io.ebean.bean.EntityBeanIntercept;
import io.ebean.bean.PersistenceContext;
import io.ebean.cache.QueryCacheEntry;
import io.ebean.cache.ServerCache;
import io.ebeaninternal.api.BeanCacheResult;
import io.ebeaninternal.api.SpiCacheControl;
import io.ebeaninternal.api.SpiCacheRegion;
import io.ebeaninternal.api.SpiTransaction;
import io.ebeaninternal.api.TransactionEventTable;
import io.ebeaninternal.server.cache.CacheChangeSet;
import io.ebeaninternal.server.cache.CachedBeanData;
import io.ebeaninternal.server.cache.CachedBeanDataFromBean;
import io.ebeaninternal.server.cache.CachedBeanDataToBean;
import io.ebeaninternal.server.cache.CachedManyIds;
import io.ebeaninternal.server.cache.SpiCacheManager;
import io.ebeaninternal.server.core.CacheOptions;
import io.ebeaninternal.server.core.PersistRequest;
import io.ebeaninternal.server.core.PersistRequestBean;
import io.ebeaninternal.server.deploy.BeanCollectionUtil;
import io.ebeaninternal.server.deploy.BeanDescriptor;
import io.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import io.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import io.ebeaninternal.server.deploy.DCacheControl;
import io.ebeaninternal.server.deploy.DCacheControlNone;
import io.ebeaninternal.server.deploy.DCacheRegionNone;
import io.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BeanDescriptorCacheHelp<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptorCacheHelp.class);
    private static final Logger queryLog = LoggerFactory.getLogger((String)"io.ebean.cache.QUERY");
    private static final Logger beanLog = LoggerFactory.getLogger((String)"io.ebean.cache.BEAN");
    private static final Logger manyLog = LoggerFactory.getLogger((String)"io.ebean.cache.COLL");
    private static final Logger natLog = LoggerFactory.getLogger((String)"io.ebean.cache.NATKEY");
    private final BeanDescriptor<T> desc;
    private final SpiCacheManager cacheManager;
    private final CacheOptions cacheOptions;
    private final boolean cacheSharableBeans;
    private final boolean invalidateQueryCache;
    private final Class<?> beanType;
    private final String cacheName;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final String[] naturalKey;
    private final ServerCache beanCache;
    private final ServerCache naturalKeyCache;
    private final ServerCache queryCache;
    private final boolean noCaching;
    private final SpiCacheControl cacheControl;
    private final SpiCacheRegion cacheRegion;
    private boolean cacheNotifyOnAll;
    private boolean cacheNotifyOnDelete;

    BeanDescriptorCacheHelp(BeanDescriptor<T> desc, SpiCacheManager cacheManager, CacheOptions cacheOptions, boolean cacheSharableBeans, BeanPropertyAssocOne<?>[] propertiesOneImported) {
        this.desc = desc;
        this.beanType = desc.rootBeanType;
        this.cacheName = this.beanType.getSimpleName();
        this.cacheManager = cacheManager;
        this.cacheOptions = cacheOptions;
        this.invalidateQueryCache = cacheOptions.isInvalidateQueryCache();
        this.cacheSharableBeans = cacheSharableBeans;
        this.propertiesOneImported = propertiesOneImported;
        this.naturalKey = cacheOptions.getNaturalKey();
        this.queryCache = !cacheOptions.isEnableQueryCache() ? null : cacheManager.getQueryCache(this.beanType);
        if (cacheOptions.isEnableBeanCache()) {
            this.beanCache = cacheManager.getBeanCache(this.beanType);
            this.naturalKeyCache = cacheOptions.getNaturalKey() != null ? cacheManager.getNaturalKeyCache(this.beanType) : null;
        } else {
            this.beanCache = null;
            this.naturalKeyCache = null;
        }
        boolean bl = this.noCaching = this.beanCache == null && this.queryCache == null;
        if (this.noCaching) {
            this.cacheControl = DCacheControlNone.INSTANCE;
            this.cacheRegion = this.invalidateQueryCache ? cacheManager.getRegion(cacheOptions.getRegion()) : DCacheRegionNone.INSTANCE;
        } else {
            this.cacheRegion = cacheManager.getRegion(cacheOptions.getRegion());
            this.cacheControl = new DCacheControl(this.cacheRegion, this.beanCache != null, this.naturalKeyCache != null, this.queryCache != null);
        }
    }

    void deriveNotifyFlags() {
        this.cacheNotifyOnAll = this.invalidateQueryCache || this.beanCache != null || this.queryCache != null;
        boolean bl = this.cacheNotifyOnDelete = !this.cacheNotifyOnAll && this.isNotifyOnDeletes();
        if (logger.isDebugEnabled() && (this.cacheNotifyOnAll || this.cacheNotifyOnDelete)) {
            String notifyMode = this.cacheNotifyOnAll ? "All" : "Delete";
            logger.debug("l2 caching on {} - beanCaching:{} queryCaching:{} notifyMode:{} ", new Object[]{this.desc.getFullName(), this.isBeanCaching(), this.isQueryCaching(), notifyMode});
        }
    }

    private boolean isNotifyOnDeletes() {
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            if (!imported.isCacheNotifyRelationship()) continue;
            return true;
        }
        return false;
    }

    boolean isCacheNotify(PersistRequest.Type type) {
        return this.cacheRegion.isEnabled() && (this.cacheNotifyOnAll || this.cacheNotifyOnDelete && (type == PersistRequest.Type.DELETE || type == PersistRequest.Type.DELETE_PERMANENT));
    }

    boolean isQueryCaching() {
        return this.cacheControl.isQueryCaching();
    }

    boolean isBeanCaching() {
        return this.cacheControl.isBeanCaching();
    }

    boolean isNaturalKeyCaching() {
        return this.cacheControl.isNaturalKeyCaching();
    }

    boolean isCaching() {
        return this.cacheControl.isCaching();
    }

    String[] getNaturalKey() {
        return this.naturalKey;
    }

    CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    void queryCacheClear() {
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
    }

    private void queryCacheClear(CacheChangeSet changeSet) {
        if (this.queryCache != null) {
            changeSet.addClearQuery(this.desc);
        }
    }

    Object queryCacheGet(Object id) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + this.desc + ". Need explicit @Cache(enableQueryCache=true)");
        }
        Object queryResult = this.queryCache.get(id);
        if (queryLog.isDebugEnabled()) {
            if (queryResult == null) {
                queryLog.debug("   GET {}({}) - cache miss", (Object)this.cacheName, id);
            } else {
                queryLog.debug("   GET {}({}) - hit", (Object)this.cacheName, id);
            }
        }
        return queryResult;
    }

    void queryCachePut(Object id, QueryCacheEntry entry) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + this.desc + ". Need explicit @Cache(enableQueryCache=true)");
        }
        if (queryLog.isDebugEnabled()) {
            queryLog.debug("   PUT {}({})", (Object)this.cacheName, id);
        }
        this.queryCache.put(id, (Object)entry);
    }

    void manyPropRemove(String propertyName, Object parentId) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isTraceEnabled()) {
            manyLog.trace("   REMOVE {}({}).{}", new Object[]{this.cacheName, parentId, propertyName});
        }
        collectionIdsCache.remove(parentId);
    }

    void manyPropClear(String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   CLEAR {}(*).{} ", (Object)this.cacheName, (Object)propertyName);
        }
        collectionIdsCache.clear();
    }

    private CachedManyIds manyPropGet(Object parentId, String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        CachedManyIds entry = (CachedManyIds)collectionIdsCache.get(parentId);
        if (entry == null) {
            if (manyLog.isTraceEnabled()) {
                manyLog.trace("   GET {}({}).{} - cache miss", new Object[]{this.cacheName, parentId, propertyName});
            }
        } else if (manyLog.isDebugEnabled()) {
            manyLog.debug("   GET {}({}).{} - hit", new Object[]{this.cacheName, parentId, propertyName});
        }
        return entry;
    }

    boolean manyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId, Boolean readOnly) {
        if (many.isElementCollection()) {
            return false;
        }
        CachedManyIds entry = this.manyPropGet(parentId, many.getName());
        if (entry == null) {
            return false;
        }
        EntityBean ownerBean = bc.getOwnerBean();
        EntityBeanIntercept ebi = ownerBean._ebean_getIntercept();
        PersistenceContext persistenceContext = ebi.getPersistenceContext();
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        List<Object> idList = entry.getIdList();
        bc.checkEmptyLazyLoad();
        int i = 0;
        for (Object id : idList) {
            EntityBean ref = targetDescriptor.createReference(readOnly, id, persistenceContext);
            if (many.hasOrderColumn()) {
                ref._ebean_getIntercept().setSortOrder(++i);
            }
            many.add(bc, ref);
        }
        return true;
    }

    void manyPropPut(BeanPropertyAssocMany<?> many, Object details, Object parentId) {
        if (many.isElementCollection()) {
            CachedBeanData data = (CachedBeanData)this.beanCache.get(parentId);
            if (data != null) {
                try {
                    String asJson = many.jsonWriteCollection(details);
                    HashMap<String, Object> changes = new HashMap<String, Object>();
                    changes.put(many.getName(), asJson);
                    CachedBeanData newData = data.update(changes, data.getVersion());
                    if (beanLog.isDebugEnabled()) {
                        beanLog.debug("   UPDATE {}({})  changes:{}", new Object[]{this.cacheName, parentId, changes});
                    }
                    this.beanCache.put(parentId, (Object)newData);
                }
                catch (IOException e) {
                    logger.error("Error updating L2 cache", (Throwable)e);
                }
            }
        } else {
            CachedManyIds entry = this.createManyIds(many, details);
            if (entry != null) {
                this.cachePutManyIds(parentId, many.getName(), entry);
            }
        }
    }

    void cachePutManyIds(Object parentId, String manyName, CachedManyIds entry) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, manyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   PUT {}({}).{} - ids:{}", new Object[]{this.cacheName, parentId, manyName, entry});
        }
        collectionIdsCache.put(parentId, (Object)entry);
    }

    private CachedManyIds createManyIds(BeanPropertyAssocMany<?> many, Object details) {
        Collection<?> actualDetails = BeanCollectionUtil.getActualDetails(details);
        if (actualDetails == null) {
            return null;
        }
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        ArrayList<Object> idList = new ArrayList<Object>(actualDetails.size());
        for (Object bean : actualDetails) {
            idList.add(targetDescriptor.getId((EntityBean)bean));
        }
        return new CachedManyIds(idList);
    }

    BeanCacheResult<T> cacheIdLookup(PersistenceContext context, Collection<?> ids) {
        HashSet<String> keys = new HashSet<String>(ids.size());
        for (Object id : ids) {
            keys.add(this.desc.cacheKey(id));
        }
        Map beanDataMap = this.beanCache.getAll(keys);
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   MGET {}({}) - hits:{}", new Object[]{this.cacheName, ids, beanDataMap.keySet()});
        }
        BeanCacheResult<T> result = new BeanCacheResult<T>();
        for (Map.Entry entry : beanDataMap.entrySet()) {
            CachedBeanData cachedBeanData = (CachedBeanData)entry.getValue();
            T bean = this.convertToBean(entry.getKey(), false, context, cachedBeanData);
            result.add(bean, this.desc.getBeanId(bean));
        }
        return result;
    }

    BeanCacheResult<T> naturalKeyLookup(PersistenceContext context, Set<Object> keys) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        Map naturalKeyMap = this.naturalKeyCache.getAll(keys);
        if (natLog.isTraceEnabled()) {
            natLog.trace(" MLOOKUP {}({}) - hits:{}", new Object[]{this.cacheName, keys, naturalKeyMap});
        }
        BeanCacheResult<T> result = new BeanCacheResult<T>();
        if (naturalKeyMap.isEmpty()) {
            return result;
        }
        HashMap reverseMap = new HashMap();
        for (Map.Entry entry : naturalKeyMap.entrySet()) {
            reverseMap.put(entry.getValue(), entry.getKey());
        }
        HashSet ids = new HashSet(naturalKeyMap.values());
        Map beanDataMap = this.beanCache.getAll(ids);
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   MGET {}({}) - hits:{}", new Object[]{this.cacheName, ids, beanDataMap.keySet()});
        }
        for (Map.Entry entry : beanDataMap.entrySet()) {
            Object id = entry.getKey();
            CachedBeanData cachedBeanData = (CachedBeanData)entry.getValue();
            T bean = this.convertToBean(id, false, context, cachedBeanData);
            Object naturalKey = reverseMap.get(id);
            result.add(bean, naturalKey);
        }
        return result;
    }

    private void setupContext(Object bean, PersistenceContext context) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        EntityBean entityBean = (EntityBean)bean;
        EntityBeanIntercept ebi = entityBean._ebean_getIntercept();
        ebi.setPersistenceContext(context);
        Object id = this.desc.getId(entityBean);
        this.desc.contextPut(context, id, bean);
    }

    private ServerCache getBeanCache() {
        if (this.beanCache == null) {
            throw new IllegalStateException("No bean cache enabled for " + this.desc + ". Add the @Cache annotation.");
        }
        return this.beanCache;
    }

    void beanCacheClear() {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.beanCache.clear();
        }
    }

    CachedBeanData beanExtractData(BeanDescriptor<?> targetDesc, EntityBean bean) {
        return CachedBeanDataFromBean.extract(targetDesc, bean);
    }

    void beanPutAll(Collection<EntityBean> beans) {
        if (this.desc.inheritInfo != null) {
            Class<?> aClass = this.theClassOf(beans);
            for (EntityBean bean : beans) {
                if (bean.getClass().equals(aClass)) continue;
                aClass = null;
                break;
            }
            if (aClass == null) {
                for (EntityBean bean : beans) {
                    this.desc.descOf(bean.getClass()).cacheBeanPutDirect(bean);
                }
            } else {
                this.desc.descOf(aClass).cacheBeanPutAllDirect(beans);
            }
        } else {
            this.beanCachePutAllDirect(beans);
        }
    }

    private Class<?> theClassOf(Collection<EntityBean> beans) {
        if (beans instanceof List) {
            return ((List)beans).get(0).getClass();
        }
        return beans.iterator().next().getClass();
    }

    void beanCachePut(EntityBean bean) {
        if (this.desc.inheritInfo != null) {
            this.desc.descOf(bean.getClass()).cacheBeanPutDirect(bean);
        } else {
            this.beanCachePutDirect(bean);
        }
    }

    void beanCachePutAllDirect(Collection<EntityBean> beans) {
        LinkedHashMap<String, String> natKeys = null;
        if (this.naturalKey != null) {
            natKeys = new LinkedHashMap<String, String>();
        }
        LinkedHashMap<String, CachedBeanData> map = new LinkedHashMap<String, CachedBeanData>();
        for (EntityBean bean : beans) {
            String naturalKey;
            CachedBeanData beanData = this.beanExtractData(this.desc, bean);
            String key = this.desc.cacheKeyForBean(bean);
            map.put(key, beanData);
            if (this.naturalKey == null || (naturalKey = this.calculateNaturalKey(beanData)) == null) continue;
            natKeys.put(naturalKey, key);
        }
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   MPUT {}({})", (Object)this.cacheName, map.keySet());
        }
        this.getBeanCache().putAll(map);
        if (natKeys != null && !natKeys.isEmpty()) {
            if (natLog.isDebugEnabled()) {
                natLog.debug(" MPUT {}({}, {})", new Object[]{this.cacheName, this.naturalKey, natKeys.keySet()});
            }
            this.naturalKeyCache.putAll(natKeys);
        }
    }

    void beanCachePutDirect(EntityBean bean) {
        String naturalKey;
        CachedBeanData beanData = this.beanExtractData(this.desc, bean);
        String key = this.desc.cacheKeyForBean(bean);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   PUT {}({}) data:{}", new Object[]{this.cacheName, key, beanData});
        }
        this.getBeanCache().put((Object)key, (Object)beanData);
        if (this.naturalKey != null && (naturalKey = this.calculateNaturalKey(beanData)) != null) {
            if (natLog.isDebugEnabled()) {
                natLog.debug(" PUT {}({}, {})", new Object[]{this.cacheName, naturalKey, key});
            }
            this.naturalKeyCache.put((Object)naturalKey, (Object)key);
        }
    }

    private String calculateNaturalKey(CachedBeanData beanData) {
        if (this.naturalKey.length == 1) {
            Object data = beanData.getData(this.naturalKey[0]);
            return data == null ? null : data.toString();
        }
        StringBuilder sb = new StringBuilder();
        for (String key : this.naturalKey) {
            Object val = beanData.getData(key);
            if (val == null) {
                return null;
            }
            sb.append(val).append(";");
        }
        return sb.toString();
    }

    CachedBeanData beanCacheGetData(String key) {
        return (CachedBeanData)this.getBeanCache().get((Object)key);
    }

    T beanCacheGet(String key, Boolean readOnly, PersistenceContext context) {
        T bean = this.beanCacheGetInternal(key, readOnly, context);
        if (bean != null) {
            this.setupContext(bean, context);
        }
        return bean;
    }

    private T beanCacheGetInternal(String key, Boolean readOnly, PersistenceContext context) {
        CachedBeanData data = (CachedBeanData)this.getBeanCache().get((Object)key);
        if (data == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - cache miss", (Object)this.cacheName, (Object)key);
            }
            return null;
        }
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   GET {}({}) - hit", (Object)this.cacheName, (Object)key);
        }
        return this.convertToBean(key, readOnly, context, data);
    }

    private T convertToBean(Object id, Boolean readOnly, PersistenceContext context, CachedBeanData data) {
        Object bean;
        if (this.cacheSharableBeans && !Boolean.FALSE.equals(readOnly) && (bean = data.getSharableBean()) != null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - hit shared bean", (Object)this.cacheName, id);
            }
            if (this.desc.isReadAuditing()) {
                this.desc.readAuditBean("l2", "", bean);
            }
            return (T)bean;
        }
        return (T)this.loadBean(id, readOnly, data, context);
    }

    private EntityBean loadBean(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        String discValue = data.getDiscValue();
        if (discValue == null) {
            return this.loadBeanDirect(id, readOnly, data, context);
        }
        return this.rootDescriptor(discValue).cacheBeanLoadDirect(id, readOnly, data, context);
    }

    private BeanDescriptor<?> rootDescriptor(String discValue) {
        return this.desc.inheritInfo.readType(discValue).desc();
    }

    EntityBean loadBeanDirect(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        id = this.desc.convertId(id);
        EntityBean bean = null;
        if (context == null) {
            context = new DefaultPersistenceContext();
        } else {
            bean = (EntityBean)this.desc.contextGet(context, id);
        }
        if (bean == null) {
            bean = this.desc.createEntityBean();
            this.desc.setId(id, bean);
            this.desc.contextPut(context, id, bean);
            EntityBeanIntercept ebi = bean._ebean_getIntercept();
            ebi.setBeanLoader((BeanLoader)this.desc.l2BeanLoader());
            if (Boolean.TRUE.equals(readOnly)) {
                ebi.setReadOnly(true);
            }
            ebi.setPersistenceContext(context);
        }
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        if (this.desc.isReadAuditing()) {
            this.desc.readAuditBean("l2", "", bean);
        }
        return bean;
    }

    EntityBean embeddedBeanLoad(CachedBeanData data, PersistenceContext context) {
        String discValue = data.getDiscValue();
        if (discValue == null) {
            return this.embeddedBeanLoadDirect(data, context);
        }
        return this.rootDescriptor(discValue).cacheEmbeddedBeanLoadDirect(data, context);
    }

    EntityBean embeddedBeanLoadDirect(CachedBeanData data, PersistenceContext context) {
        EntityBean bean = this.desc.createEntityBean();
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        return bean;
    }

    void beanCacheApplyInvalidate(Collection<String> keys) {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   MREMOVE {}({})", (Object)this.cacheName, keys);
            }
            this.beanCache.removeAll(new HashSet<String>(keys));
        }
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheClear();
        }
    }

    Set<EntityBeanIntercept> beanCacheLoadAll(List<EntityBeanIntercept> list, PersistenceContext context, int lazyLoadProperty, String propertyName) {
        HashMap<String, EntityBeanIntercept> ebis = new HashMap<String, EntityBeanIntercept>();
        for (EntityBeanIntercept ebi : list) {
            ebis.put(this.desc.cacheKeyForBean(ebi.getOwner()), ebi);
        }
        Map hits = this.getBeanCache().getAll(ebis.keySet());
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   MLOAD {}({}) - got hits ({})", new Object[]{this.cacheName, ebis.keySet(), hits.size()});
        }
        HashSet<EntityBeanIntercept> loaded = new HashSet<EntityBeanIntercept>();
        Iterator iterator = hits.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry hit = iterator.next();
            Object key = hit.getKey();
            EntityBeanIntercept ebi = (EntityBeanIntercept)ebis.remove(key);
            CachedBeanData cacheData = (CachedBeanData)hit.getValue();
            if (lazyLoadProperty > -1 && !cacheData.isLoaded(propertyName)) {
                if (beanLog.isTraceEnabled()) {
                    beanLog.trace("   load {}({}) - cache miss on property({})", new Object[]{this.cacheName, key, propertyName});
                }
                iterator.remove();
                continue;
            }
            CachedBeanDataToBean.load(this.desc, ebi.getOwner(), cacheData, context);
            loaded.add(ebi);
            if (!beanLog.isDebugEnabled()) continue;
            beanLog.debug("   load {}({}) - hit", (Object)this.cacheName, key);
        }
        if (!ebis.isEmpty() && beanLog.isTraceEnabled()) {
            beanLog.trace("   load {}({}) - cache miss", (Object)this.cacheName, ebis.keySet());
        }
        return loaded;
    }

    boolean beanCacheLoad(EntityBean bean, EntityBeanIntercept ebi, String key, PersistenceContext context) {
        CachedBeanData cacheData = (CachedBeanData)this.getBeanCache().get((Object)key);
        if (cacheData == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss", (Object)this.cacheName, (Object)key);
            }
            return false;
        }
        int lazyLoadProperty = ebi.getLazyLoadPropertyIndex();
        if (lazyLoadProperty > -1 && !cacheData.isLoaded(ebi.getLazyLoadProperty())) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss on property({})", new Object[]{this.cacheName, key, ebi.getLazyLoadProperty()});
            }
            return false;
        }
        CachedBeanDataToBean.load(this.desc, bean, cacheData, context);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   LOAD {}({}) - hit", (Object)this.cacheName, (Object)key);
        }
        return true;
    }

    void cacheUpdateQuery(boolean update, SpiTransaction transaction) {
        if (this.invalidateQueryCache || this.cacheNotifyOnAll || !update && this.cacheNotifyOnDelete) {
            transaction.getEvent().add(this.desc.getBaseTable(), false, update, !update);
        }
    }

    void persistDeleteIds(Collection<Object> ids, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache != null) {
                changeSet.addBeanRemoveMany(this.desc, ids);
            }
            this.cacheDeleteImported(true, null, changeSet);
        }
    }

    void persistDelete(Object id, PersistRequestBean<T> deleteRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache != null) {
                changeSet.addBeanRemove(this.desc, id);
            }
            this.cacheDeleteImported(true, deleteRequest.getEntityBean(), changeSet);
        }
    }

    void persistInsert(PersistRequestBean<T> insertRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            this.cacheDeleteImported(false, insertRequest.getEntityBean(), changeSet);
            changeSet.addBeanInsert(this.desc.getBaseTable());
        }
    }

    private void cacheDeleteImported(boolean clear, EntityBean entityBean, CacheChangeSet changeSet) {
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheDelete(clear, entityBean, changeSet);
        }
    }

    void persistUpdate(Object id, PersistRequestBean<T> updateRequest, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
        } else {
            this.queryCacheClear(changeSet);
            if (this.beanCache == null) {
                return;
            }
            List<BeanPropertyAssocMany<?>> manyCollections = updateRequest.getUpdatedManyForL2Cache();
            if (manyCollections != null) {
                for (BeanPropertyAssocMany<?> many : manyCollections) {
                    Object details;
                    CachedManyIds entry = this.createManyIds(many, details = many.getValue(updateRequest.getEntityBean()));
                    if (entry == null) continue;
                    changeSet.addManyPut(this.desc, many.getName(), id, entry);
                }
            }
            updateRequest.addBeanUpdate(changeSet);
        }
    }

    void persistTableIUD(TransactionEventTable.TableIUD tableIUD, CacheChangeSet changeSet) {
        if (this.invalidateQueryCache) {
            changeSet.addInvalidate(this.desc);
            return;
        }
        if (this.noCaching) {
            return;
        }
        changeSet.addClearQuery(this.desc);
        if (tableIUD.isUpdateOrDelete()) {
            changeSet.addClearBean(this.desc);
        }
        for (BeanPropertyAssocOne<?> imported : this.propertiesOneImported) {
            imported.cacheClear(changeSet);
        }
    }

    void cacheNaturalKeyPut(String key, String newKey) {
        if (newKey != null) {
            this.naturalKeyCache.put((Object)newKey, (Object)key);
        }
    }

    void cacheBeanUpdate(String key, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        ServerCache cache = this.getBeanCache();
        CachedBeanData existingData = (CachedBeanData)cache.get((Object)key);
        if (existingData != null) {
            String oldKey;
            long currentVersion = existingData.getVersion();
            if (version > 0L && version < currentVersion) {
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   REMOVE {}({}) - version conflict old:{} new:{}", new Object[]{this.cacheName, key, currentVersion, version});
                }
                cache.remove((Object)key);
            } else {
                if (version == 0L) {
                    version = currentVersion;
                }
                CachedBeanData newData = existingData.update(changes, version);
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   UPDATE {}({})  changes:{}", new Object[]{this.cacheName, key, changes});
                }
                cache.put((Object)key, (Object)newData);
            }
            if (updateNaturalKey && (oldKey = this.calculateNaturalKey(existingData)) != null) {
                if (natLog.isDebugEnabled()) {
                    natLog.debug(".. update {} REMOVE({}) - old key for ({})", new Object[]{this.cacheName, oldKey, key});
                }
                this.naturalKeyCache.remove((Object)oldKey);
            }
        }
    }
}

